/* eslint-disable max-len */
/* eslint-disable no-var */
/* eslint valid-jsdoc: "error"*/
/* eslint-env es6*/


/**
 * Check whether the left if the instance of the right.
 * @param {number} left the instance of the node.
 * @param {number} right the instance type.
 * @returns {boolean} whether the left if the instance of the right.
 */
function _instanceof(left, right) {
    if (
        right != null &&
        typeof Symbol !== 'undefined' &&
        right[Symbol.hasInstance]
    ) {
        return !!right[Symbol.hasInstance](left);
    } else {
        return left instanceof right;
    }
}

// #region window.getMatchedCSSRules
if (typeof window.getMatchedCSSRules == 'undefined') {
    /**
     * 这个函数可以返回与safari上相同的CSSRuleList列表
     * @param {Object} element DOM element.
     * @returns {string} 指定Element的CSSRuleList列表。
     */
    window.getMatchedCSSRules = function(element) {
        var i;
        var len;
        var matching = [];
        var sheets = document.styleSheets;

        /**
         * Loop and find matched css rules which are
         * applied to the specified element.
         * @param {Array.<Object>} rules css rules.
         * @return {void}
         */
        function loopRules(rules) {
            var i;
            var len;
            var rule;
            try {
                for (i = 0, len = rules.length; i < len; i++) {
                    rule = rules[i];
                    try {
                        if (rule instanceof CSSMediaRule) {
                            if (window.matchMedia(rule.conditionText).matches) {
                                loopRules(rule.cssRules);
                            }
                        } else if (rule instanceof CSSStyleRule) {
                            if (element.matches(rule.selectorText)) {
                                matching.push(rule);
                            }
                        }
                    } catch (error) {
                        console.log(error);
                    }
                }
            } catch (error) {
            }
        }

        for (i = 0, len = sheets.length; i < len; i++) {
            try {
                if (sheets[i].cssRules) {
                    loopRules(sheets[i].cssRules);
                }
            } catch (error) {
            }
        }

        return matching;
    };
}
// #endregion

/**
 * Gets iframe source url.
 * @param {object} args parameters that contains information about the iframe.
 * @return {string} the iframe source url.
 */
function getIframeSrc(args) {
    var iframeSrc = null;
    if (typeof window.YXJSBridge !== 'undefined') {
        iframeSrc = window.YXJSBridge.articleIframeSrc();
    } else if (typeof args !== 'undefined') {
        EVELog.debug('clipArticle arguments are ' + JSON.stringify(args));
        iframeSrc = args.iframeSrc;
    }
    EVELog.debug('iframeSrc is ' + iframeSrc);
    return iframeSrc;
}

// #region EVELog
var EVELog = {
    _logWithPrefix: function _logWithPrefix(prefix, args) {
        var _args = Array.prototype.slice.call(args);
        var msg = (prefix) ? '[' + prefix + '] ' + _args : _args;
        console.log(msg);
        if (typeof webkit !== 'undefined') {
            webkit.messageHandlers.yxloghandler.postMessage({'log': msg});
        }
    },
    debug: function debug() {
        this._logWithPrefix('DEBUG', arguments);
    },
    info: function info() {
        this._logWithPrefix('INFO', arguments);
    },
    warn: function warn() {
        this._logWithPrefix('WARN', arguments);
    },
    error: function error() {
        this._logWithPrefix('ERROR', arguments);
    },
    _Durations: {},
    debugDuration: function debugDuration(fn, msg) {
        var start = Date.now();
        fn();
        var end = Date.now();
        var fnName = fn.name || '(anonymous function)';
        console.log('Duration of ' + fnName + ': ' + (end - start) + 'ms');
    },
    debugStartDuration: function debugStartDuration(key) {
        EVELog._Durations[key] = Date.now();
    },
    debugEndDuration: function debugEndDuration(key) {
        var duration = Date.now() - EVELog._Durations[key];
        delete EVELog._Durations[key];
        console.log('Duration of ' + key + ': ' + duration + 'ms');
    },
    prettyFunction: function prettyFunction(context, logArgs, includeCaller) {
        var caller = arguments.callee.caller;
        var constructor = typeof context == 'string' ? context : context.constructor.name;
        var callerName = caller.name || '__anonymous__';
        var parts = (constructor ? [constructor] : []).concat(callerName);
        var out = parts.join('.');

        if (logArgs && typeof context != 'string') {
            var args = caller['arguments'];

            if (args) {
                var argStrings = Array.prototype.slice.call(args);

                for (var i = 0; i < argStrings.length; i++) {
                    var arg = argStrings[i];

                    if (typeof arg == 'string') {
                        argStrings[i] = '"' + arg + '"';
                    } else if (_instanceof(arg, Node)) {
                        var txt = arg.textContent.trim();

                        if (txt.length > 10) {
                            txt = txt.substring(0, 7) + '...';
                        }

                        argStrings[i] = arg.nodeName + '[' + txt + ']';
                    } else if (_instanceof(arg, HTMLElement)) {
                        argStrings[i] = '<' + arg.nodeName + '>';
                    }
                }

                out += '(' + argStrings.join(', ') + ')';
            }
        }

        if (includeCaller) {
            var parentCaller = caller.caller;
            out += ' <- ' + (parentCaller ? parentCaller.name : '__anonymous__');
        }

        console.log(out);
    },
};
// #endregion

// #region ClientRect
var ClientRect = function() {
};

ClientRect.prototype.toString = function toString() {
    return this.toCGRectString();
};

ClientRect.prototype.toCGRectString = function toCGRectString() {
    return '{{'+this.left+','+this.top+'},{'+this.width+','+this.height+'}}';
};
// #endregion

// #region EvernoteExtension
var EvernoteExtension = function() {
};
EvernoteExtension.prototype.PLATFORM_ANDROID = 0;
EvernoteExtension.prototype.PLATFORM_IOS = 1;
EvernoteExtension.prototype.PLATFORM_WINDOWS = 2;
EvernoteExtension.prototype.PLATFORM_MAC = 3;
EvernoteExtension.prototype.PLATFORM_BACKEND = 4;
EvernoteExtension.prototype.pseudoStyles = null;
EvernoteExtension.prototype.usePseudoStyles = true;
EvernoteExtension.prototype.initPseudoStyles = function initPseudoStyles() {
    // 既有版本, CSS 处理逻辑, 已被 native 代码替换实现. 既有遗留代码中的 sheets[i].cssRules 会触发 CSS 跨域访问的报错, 导致 JS 报错, EvernoteExtension 注入失败.
};
EvernoteExtension.prototype.ESSENTIAL_ELEMENT_STYLE_PROPS = ['display', 'box-sizing', 'padding', 'margin', 'white-space', '-webkit-appearance', '-webkit-align-items'];
EvernoteExtension.prototype.STRIP_STYLE_PROPS = ['-webkit-user-select', '-webkit-user-modify'];
EvernoteExtension.prototype.stripHiddenElements = true;
EvernoteExtension.prototype.convertFixedPositionedElements = true;

EvernoteExtension.prototype.findiFrameArticle = function findiFrameArticle(targetFrameURL) {
    var iframes = document.querySelectorAll('iframe');
    var result = null;
    for (var i = 0; i < iframes.length; i++) {
        var src = iframes[i].src;
        if (src != null && src.search(targetFrameURL) !== -1) {
            result = src;
            break;
        }
    }
    return result;
};

EvernoteExtension.prototype.findiFrame = function findiFrame(targetFrameURL) {
    if (targetFrameURL === null) {
        return null;
    }
    var iframes = document.querySelectorAll('iframe');
    var result = null;
    for (var i = 0; i < iframes.length; i++) {
        var src = iframes[i].src;
        if (src != null && src.search(targetFrameURL) !== -1) {
            result = iframes[i];
            break;
        }
    }
    return result;
};

EvernoteExtension.prototype.inlineStyles = function inlineStyles(src, dest) {
    var inputStyle = window.getMatchedCSSRules(src, '');
    if (!dest) {
        dest = src;
    }

    var outputStyles = [];

    var len = inputStyle ? inputStyle.length : 0;
    var i=0;
    var style = null;
    for (i=0; i<len; i++) {
        style = inputStyle[i].style;
        var bgLength = (style.backgroundImage) ? style.backgroundImage.length : 0;
        if (bgLength > 131072) {
            EVELog.warn('Removing large background image css property (len: '+bgLength+')');
            style.backgroundImage = '';
        }
        if (style.cssText.length > 131072) {
            EVELog.warn('Ignoring outrageously long style cssText');
            continue;
        }
        outputStyles.push(style.cssText);
    }

    if (dest.style.cssText) {
        outputStyles.push(dest.style.cssText);
    }

    if (outputStyles.length > 0) {
        dest.setAttribute('style', outputStyles.join(' '));
    }
    style = dest.style;
    var strip = this.STRIP_STYLE_PROPS;
    for (i=0; i<strip.length; i++) {
        var prop = strip[i];
        if (style[prop]) {
            style[prop] = '';
        }
    }
};

EvernoteExtension.prototype.sanitizeNode = function sanitizeNode(node) {
    node.removeAttribute('id');
    node.removeAttribute('class');
};

EvernoteExtension.prototype.getViewportMetrics = function getViewportMetrics() {
    var meta = document.querySelectorAll('meta[name="viewport"]');
    if (!meta || meta.length === 0) {
        return null;
    }
    meta = meta[meta.length - 1];
    var content = ''+meta.content;
    var parts = content.split(/,\s*/);
    var result = {};
    for (var i=0; i<parts.length; i++) {
        var part = parts[i];
        var kv = part.split('=');
        if (kv.length < 2) {
            continue;
        }
        result[kv[0].toLowerCase()] = kv[1];
    }
    return result;
};

EvernoteExtension.prototype.restoreSelection = function restoreSelection() {
    EVELog.prettyFunction(this);
    var childIndex = null;
    var baseOffset = 0;
    var extentOffset = 0;

    var baseNode = document.querySelector('*['+'ensclipper-baseNode'+']');
    if (baseNode) {
        baseOffset = parseInt(baseNode.getAttribute('ensclipper-baseOffset'), 10);
        childIndex = parseInt(baseNode.getAttribute('ensclipper-baseNode-child-index'), 10);
        if (!isNaN(childIndex)) {
            baseNode = baseNode.childNodes[childIndex];
        }
    }

    var extentNode = document.querySelector('*['+'ensclipper-extentNode'+']');
    if (extentNode) {
        extentOffset = parseInt(extentNode.getAttribute('ensclipper-extentOffset'), 10);
        childIndex = parseInt(extentNode.getAttribute('ensclipper-extentNode-child-index'), 10);
        if (!isNaN(childIndex)) {
            extentNode = extentNode.childNodes[childIndex];
        }
    }

    if (baseNode && extentNode) {
        var sel = window.getSelection();
        sel.setBaseAndExtent(baseNode, baseOffset, extentNode, extentOffset);
    }
};

EvernoteExtension.prototype.saveOriginalContent = function saveOriginalContent() {
    if (!this._originalDocument) {
        this._originalDocument = document.body.cloneNode(true);
    }
};

EvernoteExtension.prototype.restoreOriginalContent = function restoreOriginalContent() {
    if (this._originalDocument) {
        document.body = this._originalDocument.cloneNode(true);
    }
};

EvernoteExtension.prototype._prepInnerElementForRoot = function _prepInnerElementForRoot(element) {
    if (!element) {
        return;
    }
    var computedStyle = window.getComputedStyle(element, '');
    var rootStyle = element.style;
    rootStyle.width = '';
    rootStyle.height = '';
    rootStyle.float = '';
    rootStyle.clear = '';
    rootStyle.display = 'block';
    var enforceStyleProperties = {
        'background-color': null,
        'background-image': null,
        'background-position': null,
        'background-repeat': null,
        'font': null,
        'text-decoration': null,
        'color': null,
    };
    // eslint-disable-next-line guard-for-in
    for (var prop in enforceStyleProperties) {
        rootStyle[prop] = computedStyle.getPropertyValue(prop);
    }

    var absolute = element.querySelectorAll('*[style*="position: absolute"]');
    var length = (absolute) ? absolute.length : 0;

    for (var a=0; a<length; a++) {
        var el = absolute[a];
        var elRect = el.getBoundingClientRect();
        var parentRect = el.parentElement.getBoundingClientRect();
        if (!elRect || !parentRect) {
            continue;
        }
        var elStyle = el.style;
        if (elStyle.left) {
            elStyle.left = (elRect.left - parentRect.left)+ 'px';
        }
        if (elStyle.top) {
            elStyle.top = (elRect.top - parentRect.top) + 'px';
        }
        if (elStyle.bottom) {
            elStyle.bottom = (parentRect.bottom - elRect.bottom) + 'px';
        }
        if (elStyle.right) {
            elStyle.right = (parentRect.right - elRect.right) + 'px';
        }
    }
};

EvernoteExtension.prototype.clipDocumentURL = function clipDocumentURL() {
    var a = document.createElement('a');
    a.href = document.location.href;
    var text = document.title;
    if (!text) {
        text = document.location.href;
    }
    a.innerText = text;
    var result = this._clip(a);
    return result;
};

EvernoteExtension.prototype.clipFullPage = function clipFullPage(args) {
    if (!this._originalDocument) {
        this.saveOriginalContent();
    }

    var iframeSrc = getIframeSrc(args);

    if (typeof iframeSrc == 'undefined' || iframeSrc === null || iframeSrc === '') {
        return this._clip(document.body);
    } else {
        var iframe = this.findiFrame(iframeSrc);
        if (iframe === null) {
            return this._clip(document.body);
        } else {
            EVELog.debug('iframe found :'+iframe.src);
            return this._clip(iframe.contentWindow.document.body);
        }
    }
};

EvernoteExtension.prototype.clipSelection = function clipSelection() {
    if (!this._originalDocument) {
        this.saveOriginalContent();
    }
    this.restoreSelection();

    var sel = window.getSelection();
    var baseNode = null;
    var baseOffset = 0;
    var extentNode = null;
    var extentOffset = 0;
    if (sel && !sel.isCollapsed) {
        baseNode = sel.baseNode;
        baseOffset = sel.baseOffset;
        if (baseNode.nodeType == Node.ELEMENT_NODE) {
            baseNode = baseNode.childNodes[baseOffset];
        }
        extentNode = sel.extentNode;
        extentOffset = sel.extentOffset;
        if (extentNode.nodeType == Node.ELEMENT_NODE) {
            extentNode = extentNode.childNodes[extentOffset];
        }
    }
    var hasSelection = (baseNode && extentNode && !isNaN(baseOffset) && !isNaN(extentOffset)) ? true : false;
    if (!hasSelection) {
        return this.clipBody();
    }

    var r = sel.getRangeAt(0);
    var rootElement = r.commonAncestorContainer;
    if (rootElement.nodeType != Node.ELEMENT_NODE) {
        rootElement = rootElement.parentElement;
    }
    var toRemove = [];

    var filter = function filter(node) {
        if (node == baseNode || node == extentNode) {
            return NodeFilter.FILTER_ACCEPT;
        }
        var result = NodeFilter.FILTER_ACCEPT;
        if (!r.intersectsNode(node)) {
            toRemove.push(node);
            result = NodeFilter.FILTER_REJECT;
        } else {
            var baseNodeComparison = baseNode.compareDocumentPosition(node);
            if (baseNodeComparison & Node.DOCUMENT_POSITION_PRECEDING && !(baseNodeComparison & Node.DOCUMENT_POSITION_CONTAINS)) {
                toRemove.push(node);
            }
            var extentNodeComparison = extentNode.compareDocumentPosition(node);
            if (extentNodeComparison & Node.DOCUMENT_POSITION_FOLLOWING && !(extentNodeComparison & Node.DOCUMENT_POSITION_CONTAINS)) {
                toRemove.push(node);
            }
        }
        return result;
    };

    var self = this;
    var postProcess = function final(root) {
        self._prepInnerElementForRoot(root);

        EVELog.debug('Removing: ');
        console.dir(toRemove);
        for (var r=0; r<toRemove.length; r++) {
            var excludedNode = toRemove[r];
            excludedNode.parentElement.removeChild(excludedNode);
        }
        var newTextContent;
        if (extentNode.nodeType == Node.TEXT_NODE && extentOffset < extentNode.textContent.length) {
            newTextContent = extentNode.textContent.substring(0, extentOffset);
            EVELog.debug('Trimming extentNode: ' + newTextContent);
            extentNode.textContent = newTextContent;
        }
        if (baseNode.nodeType == Node.TEXT_NODE && baseOffset > 0) {
            newTextContent = baseNode.textContent.substring(baseOffset);
            EVELog.debug('Trimming baseNode: ' + newTextContent);
            baseNode.textContent = newTextContent;
        }
    };
    return this._clip(rootElement, filter, postProcess);
};

EvernoteExtension.prototype._getReadabilityInfo = function _getReadabilityInfo(doc) {
    EVELog.prettyFunction(this);
    EVELog.debugStartDuration('_getReadabilityInfo');
    window['readConvertLinksToFootnotes'] = false;
    window['readStyle'] = 'style-newspaper';
    window['readSize'] = 'size-medium';
    window['readMargin'] = 'margin-wide';

    var error = '';
    var articleTitle = '';
    var articleContent = '';
    var imageSources = [];
    try {
        try {
            if (doc === null) {
                doc = document;
            }
            readability.clickExpandable();
            var body = doc.body;
            var iterator = doc.createTreeWalker(body, NodeFilter.SHOW_ELEMENT, null);
            this.inlineStyles(doc.documentElement);
            body.style.cssText = doc.documentElement.style.cssText + body.style.cssText;
            var node = null;
            var removeNodeNames = {
                'STYLE': null,
            };
            var toRemoveNodes = [];
            while ((node = iterator.nextNode())) {
                if (node.nodeType != Node.ELEMENT_NODE) {
                    continue;
                }
                if (readability.isImageElement(node)) {
                    dbg('image element');
                }
                var nodeName = node.nodeName;
                if (typeof removeNodeNames[nodeName] != 'undefined' ||
                    (this.stripHiddenElements && 
                        node.style.display == 'none' && 
                        !readability.shouldReserveNode(node)) ||
                        readability.isWeChatPlaceHolder(node)) {
                    toRemoveNodes.push(node);
                    continue;
                }
                this.inlineStyles(node);
            }
            for (var i = 0; i < toRemoveNodes.length; i++) {
                var node = toRemoveNodes[i];
                node.parentElement.removeChild(node);
            }
        } catch (error) {
            dbg(error.toString());
        }

        if (readability.isBaiduNews()) {
            var divs = doc.querySelectorAll('.mainContent');
            if (divs.length > 0) {
                var mainContent = divs[0];
                dbg('---find baidu news main content----');
                if (mainContent) {
                    mainContent.setAttribute('style', 'height:100%');
                }
            }
        } else if (readability.isRenmin()) {
            var imgPlaceHolders = doc.querySelectorAll('i.img-bitmap-loading.animated');
            for (var i = 0; i < imgPlaceHolders.length; i++) {
                var element = imgPlaceHolders[i];
                element.parentNode.removeChild(element);
            }
        }

        readability.parsedPages[window.location.href.replace(/\/$/, '')] = true;
        articleTitle = readability.getArticleTitle(doc);
        var article = readability.grabArticle(doc.body);
        var imgs = article.getElementsByTagName('img');
        var imgsLength = (imgs) ? imgs.length : 0;
        var coverSrc = null;
        var isFirstImageLoaded = false;
        var firstVisibleImageChecked = false;
        for (var i=0; i<imgsLength; i++) {
            var img = imgs[i];
            if (!readability.nodeIsVisible(img)) {
                continue;
            }

            if (!firstVisibleImageChecked) {
                isFirstImageLoaded = readability.isImageLoaded(img);
                firstVisibleImageChecked = true;
            }

            if (coverSrc == null && readability.isValidCoverImage(img)) {
                coverSrc = src;
            }

            var src = this._fetchImgNodeSrc(img);
            if (src != null) {
                imageSources.push(src);
                img.setAttribute('src', src);
            }

            // https://yinxiang.atlassian.net/browse/IOS-25022 头条文章中的图片
            // 在未加载时，会显示一个默认图，所以每个图片都会默认给一个padding，但是我们剪藏的时候
            // 这个padding是不需要的，所以要去掉
            if (readability.isTouTiao()) {
                img.style.cssText = this.cleanStyle(['padding'], img.style.cssText);
            }

            var parentSPAN = img.parentNode;
            if ( parentSPAN != null &&
                parentSPAN.childElementCount === 1 &&
                parentSPAN.tagName === 'SPAN' &&
                readability.isXuexiQiangGuo()) {
                dbg('----------- replacing span to div');
                var newNode = doc.createElement('div');
                try {
                    newNode.style.cssText = parentSPAN.style.cssText;
                    newNode.innerHTML = parentSPAN.innerHTML;
                    parentSPAN.parentNode.replaceChild(newNode, parentSPAN);
                } catch (e) {
                    dbg('Could not alter div to p, probably an IE restriction, reverting back to div.: ' + e);
                }
            }
        }
        this.applyYXStyle(article);
        articleContent = article.outerHTML;
        var videoSources = readability.getVideoSource(article);
        var siteName = readability.getSiteName();
    } catch (e) {
        error = e;
        dbg(error.toString());
    }
    var result = {
        'content': articleContent,
        'title': articleTitle,
        'baseURL': doc.baseURI,
        'imageSources': imageSources,
        'videoSources': videoSources,
        'siteName': siteName,
        'coverSrc': coverSrc,
        'isFirstImageLoaded': isFirstImageLoaded,
    };
    EVELog.debugEndDuration('_getReadabilityInfo');
    var paltform = window.YXJSBridge.platform();
    if (paltform === this.PLATFORM_ANDROID || paltform === this.PLATFORM_BACKEND) {
        return JSON.stringify(result);
    }
    return result;
};

EvernoteExtension.prototype.applyYXStyle = function(e) {
    e.style.cssText = 'font-size: 16px;font-family:PingFangSC-Regular;letter-spacing: 1px;line-height:33px;text-align: justify;';
    var allElements = e.getElementsByTagName('*');
    var node = null;
    var eliminateBackgroundColor = window.YXJSBridge.eliminateBackgroundColor();
    dbg('current host: ' + window.location.host);
    for (var nodeIndex = 0; (node = allElements[nodeIndex]); nodeIndex+=1) {
        if (node.tagName === 'IMG') {
            var hostRegex = /huanqiu.com|m.toutiaocdn.com/i;
            if (readability.isSpecificHost(hostRegex)) {
                node.style.cssText = this.cleanStyle(['height: 0px', 'background-image', 'background-position', 'background-repeat', 'padding'], node.style.cssText);
            } else {
                node.style.cssText = this.cleanStyle(['height: 0px', 'background-image', 'background-position', 'background-repeat'], node.style.cssText);
            }
        } else if (node.tagName === 'DIV') {
            if(eliminateBackgroundColor) {
                node.style.cssText = this.cleanStyle(['margin', 'font-size', 'letter-spacing', 'line-height', 'color'], node.style.cssText);
            } else {
                node.style.cssText = this.cleanStyle(['margin', 'font-size', 'letter-spacing', 'line-height'], node.style.cssText);
            }
            
        } else if (node.tagName === 'SPAN' || node.tagName === 'P' || node.tagName === 'FONT' || node.tagName === 'SECTION' || node.tagName === 'ARTICLE') {
            if(eliminateBackgroundColor) {
                node.style.cssText = this.cleanStyle(['font-size', 'letter-spacing', 'line-height', 'color'], node.style.cssText);
            } else {
                node.style.cssText = this.cleanStyle(['font-size', 'letter-spacing', 'line-height'], node.style.cssText);
            }
        }
    }
};

EvernoteExtension.prototype.cleanStyle = function(cleanStyles, originalStyleCssText) {
    if (!String.prototype.includes) {
        // eslint-disable-next-line no-extend-native
        String.prototype.includes = function(search, start) {
            'use strict';
            if (search instanceof RegExp) {
                // eslint-disable-next-line new-cap
                throw TypeError('first argument must not be a RegExp');
            }
            if (start === undefined) {
                start = 0;
            }
            return this.indexOf(search, start) !== -1;
        };
    }
    var result = originalStyleCssText;
    var styles = originalStyleCssText.split(';');
    for (var i = 0; i < styles.length; i++) {
        var style = styles[i];
        for (var j = 0; j < cleanStyles.length; j++) {
            var cleanStyle = cleanStyles[j];
            if (style.includes(cleanStyle)) {
                result = result.replace(style+';', '');
                // dbg('clean styles: '+ result);
            }
        }
    }
    return result;
};

EvernoteExtension.prototype.getSiteIcons = function getSiteIcons() {
    var results = [];
    var nodes = document.querySelectorAll('link[rel*="icon"]');
    for (var i=0; i<nodes.length; i++) {
        try {
            var data = {'rel': nodes[i].rel, 'href': nodes[i].href};
            if (nodes[i].size != null) {
                data['size'] = nodes[i].size;
            }
            results.push(data);
        } catch (e) {}
    }
    return results;
};

EvernoteExtension.prototype.clipArticle = function clipArticle(args) {
    EVELog.prettyFunction(this);
    if (!this._originalDocument) {
        this.saveOriginalContent();
    }
    var iframeSrc = getIframeSrc(args);
    if (typeof iframeSrc == 'undefined' || iframeSrc === null || iframeSrc === '') {
        return this._getReadabilityInfo(document);
    } else {
        var iframe = this.findiFrame(iframeSrc);
        if (iframe === null) {
            return this._getReadabilityInfo(document);
        } else {
            EVELog.debug('iframe found :'+iframe.src);
            return this._getReadabilityInfo(iframe.contentWindow.document);
        }
    }
};

EvernoteExtension.prototype._fetchImgNodeSrc = function(imgNode) {
    var src = imgNode.getAttribute('data-src');
    if (src == null || src == '') {
        src = imgNode.getAttribute('data-lazy-src');
    }
    if (src == null || src == '') {
        src = imgNode.getAttribute('data-lazyload');
    }
    if (src == null || src == '') {
        src = imgNode.getAttribute('data-bitmap');
    }
    if (src == null || src == '') {
        src = imgNode.getAttribute('data-original');
    }
    if (src == null || src == '') {
        src = imgNode.getAttribute('src');
        if (src === '') {
            src = null;
        }
    }

    if (src !== null && src !== '') {
        if (src.startsWith('/') || src.startsWith('//')) {
            try {
                var url = new URL(src, document.baseURI);
                src = url.toString();
            } catch (error) {
                dbg(error.toString());
            }
        }
    }

    return src;
};

EvernoteExtension.prototype._clip = function _clip(rootElement, filter, postProcess) {
    EVELog.prettyFunction(this);
    EVELog.debugStartDuration('clipping');
    var pseudo = null;
    var selectorSplitPattern = null;
    if (this.usePseudoStyles && !this.pseudoStyles) {
        this.initPseudoStyles();
        pseudo = this.pseudoStyles;
        selectorSplitPattern = /,\s*/;
    }
    readability.clickExpandable();
    var body = rootElement;

    var iterator = document.createTreeWalker(body, NodeFilter.SHOW_ELEMENT + ((filter) ? NodeFilter.SHOW_TEXT : 0), filter);

    var imageSources = [];
    this.inlineStyles(body);


    if (body == document.body) {
        this.inlineStyles(document.documentElement);
        body.style.cssText = document.documentElement.style.cssText + body.style.cssText;
    }


    var bodyStyle = body.style;
    if (bodyStyle.height.match(/%/)) {
        bodyStyle.height = '';
    }
    if (bodyStyle.minHeight.match(/%/)) {
        bodyStyle.minHeight = '';
    }


    if (body == document.body) {
        var viewport = this.getViewportMetrics();
        if (viewport) {
            // eslint-disable-next-line guard-for-in
            for (var viewportProp in {'width': null, 'height': null}) {
                var minValue = parseInt(viewport[viewportProp], 10);
                if (!isNaN(minValue) && isFinite(minValue)) {
                    bodyStyle['min-' + viewportProp] = minValue + 'px';
                }
            }
        }
    }

    bodyStyle.position = '';
    bodyStyle.margin = '';


    bodyStyle.cssText = bodyStyle.cssText;

    var coverSrc = null;
    var isFirstImageLoaded = false;
    var isFirstImageLoadChecked = false;
    var node = null;
    var replacements = [];
    var pseudoNodes = [];
    var i=0;
    var removeNodeNames = {
        'STYLE': null,
    };
    while ((node = iterator.nextNode())) {
        if (node.nodeType != Node.ELEMENT_NODE) {
            continue;
        }

        var nodeName = node.nodeName;

        if (typeof removeNodeNames[nodeName] != 'undefined' ||
        (this.stripHiddenElements && 
            node.style.display == 'none' && 
            !readability.shouldReserveNode(node)) ||
            readability.isWeChatPlaceHolder(node)) {
            replacements.push({'old': node, 'new': null});
            continue;
        }

        this.inlineStyles(node);

        if (pseudo) {
            // eslint-disable-next-line guard-for-in
            for (var selectorMatcher in pseudo) {
                var matched = false;
                try {
                    matched = node.matches(selectorMatcher);
                } catch (e) {
                    EVELog.warn('node.matches threw: '+e);
                }
                if (matched) {
                    var rule = pseudo[selectorMatcher];
                    var matcherParts = selectorMatcher.split(selectorSplitPattern);
                    var selectorParts = rule.selectorText.split(selectorSplitPattern);
                    var selectors = [];
                    var before = node._beforeNode;
                    var after = node._afterNode;
                    var added = false;
                    for (var p=0; p<matcherParts.length; p++) {
                        var matcherPart = matcherParts[p];
                        if (node.matches(matcherPart)) {
                            var selector = selectorParts[p];
                            selectors.push(selector);
                            if (selector.indexOf(':after') >= 0) {
                                if (!after) {
                                    after = document.createElement('span');
                                    node._afterNode = after;
                                }
                                after.style.cssText += rule.style.cssText;
                                added = true;
                            } else if (selector.indexOf(':before') >= 0) {
                                if (!before) {
                                    before = document.createElement('span');
                                    node._beforeNode = before;
                                }
                                before.style.cssText += rule.style.cssText;
                                added = true;
                            }
                        }
                    }
                    if (added) {
                        pseudoNodes.push(node);
                    }
                }
            }
        }

        var replacement = null;
        var nodeStyle = node.style;

        if (nodeName == 'IMG') {
            if (!readability.nodeIsVisible(node) && !readability.isWechatImage(node)) {
                continue;
            }

            var imgSrc = this._fetchImgNodeSrc(node);
            if (imgSrc != null) {
                imageSources.push(imgSrc);
                node.setAttribute('src', imgSrc);
            }

            if (!isFirstImageLoadChecked) {
                isFirstImageLoaded = readability.isImageLoaded(node);
                isFirstImageLoadChecked = true;
            }
            node.style.display = 'block';
            if (readability.nodeIsVisible(node) && coverSrc == null && readability.isValidCoverImage(node)) {
                coverSrc = imgSrc;
            }
        } else if (nodeName == 'A') {
            node.setAttribute('href', node.href);
        } else if (nodeName == 'SELECT') {
            var selectedOptions = node.selectedOptions;
            var replacementText = null;
            if (selectedOptions != null && selectedOptions.length > 0) {
                var selectedStrings = [];
                for (i=0; i<selectedOptions.length; i++) {
                    var selectedText = selectedOptions[i].textContent;
                    if (selectedText) {
                        selectedStrings.push(selectedText);
                    }
                }
                if (selectedOptions.length > 0) {
                    replacementText = selectedStrings.join(', ');
                }
            }

            replacement = document.createElement('div');
            if (replacementText) {
                replacement.innerText = replacementText;
            }
            replacements.push({'old': node, 'new': replacement});
        } else if (nodeName == 'INPUT' || nodeName == 'NOFRAMES') {
            replacements.push({'old': node, 'new': null});
        }

        if (nodeStyle.height && nodeStyle.position != 'absolute' && node.parentElement != body && nodeStyle.height.indexOf('100%') >= 0) {
            nodeStyle.height = '';
        }

        if (this.convertFixedPositionedElements && node.style.position == 'fixed') {
            var nodeFrame = node.getBoundingClientRect();
            var parentElement = node.parentElement;
            var parentFrame = parentElement.getBoundingClientRect();
            if (nodeStyle.top) {
                nodeStyle.top = (nodeFrame.top - parentFrame.top) + 'px';
            }
            if (nodeStyle.bottom) {
                nodeStyle.bottom = (parentFrame.bottom - nodeFrame.bottom) + 'px';
            }
            if (nodeStyle.left) {
                nodeStyle.left = (nodeFrame.left - parentFrame.left) + 'px';
            }
            if (nodeStyle.right) {
                nodeStyle.right = (parentFrame.right - nodeFrame.right) + 'px';
            }
            nodeStyle.position = 'absolute';
        }

        node.style.cssText = node.style.cssText;
    }


    var inheritStyles = this.ESSENTIAL_ELEMENT_STYLE_PROPS;
    for (i=0; i<replacements.length; i++) {
        var from = replacements[i]['old'];
        var fromParent = from.parentElement;
        if (!fromParent) {
            continue;
        }
        var to = replacements[i]['new'];
        if (!to) {
            fromParent.removeChild(from);
        } else {
            var oldStyle = window.getComputedStyle(from, '');
            var inheritStyleString = '';
            for (var s=0; s<inheritStyles.length; s++) {
                var styleName = inheritStyles[s];
                inheritStyleString += styleName + ': ' + oldStyle[styleName] + ';';
            }
            to.style.cssText = inheritStyleString + from.style.cssText;
            fromParent.replaceChild(to, from);
        }
    }


    for (i=0; i<pseudoNodes.length; i++) {
        node = pseudoNodes[i];
        var beforeNode = node._beforeNode;
        var afterNode = node._afterNode;
        if (beforeNode) {
            var firstChild = (node.childNodes.length > 0) ? node.childNodes[0] : null;
            if (!firstChild) {
                node.appendChild(beforeNode);
            } else {
                node.insertBefore(beforeNode, firstChild);
            }
        }
        if (afterNode) {
            node.appendChild(afterNode);
        }
    }

    if (typeof postProcess == 'function') {
        postProcess(body);
    }

    EVELog.debugEndDuration('clipping');

    var articleTitle = readability.getArticleTitle(document);

    if (!articleTitle || articleTitle == '') { // 微信专用的获取标题的方式.
        try {
            articleTitle = document.getElementById('activity-name').innerText;
        } catch (error) {
            console.error(error);
        }
    }

    var videoSources = readability.getVideoSource(body);
    var siteName = readability.getSiteName();

    var article = document.createElement('div');
    article.innerHTML = body.innerHTML;
    this.applyYXStyle(article);

    var result = {
        'content': article.outerHTML,
        'title': articleTitle,
        'baseURL': document.baseURI,
        'imageSources': imageSources,
        'videoSources': videoSources,
        'siteName': siteName,
        'coverSrc': coverSrc,
        'isFirstImageLoaded': isFirstImageLoaded,
    };
    var paltform = window.YXJSBridge.platform();
    if (paltform === this.PLATFORM_ANDROID || paltform === this.PLATFORM_BACKEND) {
        return JSON.stringify(result);
    }
    return result;
};

EvernoteExtension.prototype._fetchCounter = 0;
EvernoteExtension.prototype.fetchRemoteStyleSheet = function fetchRemoteStyleSheet(url) {
    EVELog.prettyFunction(this);
    if (this._fetchCounter === 0) {
        EVELog.debugStartDuration('styleSheetFetching');
    }
    var self = this;
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url);
    xhr.onreadystatechange = function onreadystatechange() {
        if (xhr.readyState == XMLHttpRequest.DONE) {
            self._fetchCounter--;
            if (self._fetchCounter < 0) {
                EVELog.warn('Unbalanced fetchCounter');
                self._fetchCounter = 0;
            }
            self.replaceRemoteStyleSheet(url, xhr.responseText);
            if (self._fetchCounter === 0) {
                EVELog.debugEndDuration('styleSheetFetching');
            }
        }
    };
    this._fetchCounter++;
    EVELog.debug('Fetching ' + url);
    xhr.send();
};

EvernoteExtension.prototype.replaceRemoteStyleSheet = function replaceRemoteStyleSheet(url, content) {
    EVELog.prettyFunction(this);
    var links = document.querySelectorAll('link[href="'+url+'"]');
    var styles = document.querySelectorAll('style');
    var i;
    var style;
    var found = false;
    if (!links || links.length === 0) {
        for (i=0; i<styles.length; i++) {
            style = styles[i];
            var cssText = style.innerText;
            var urlForPattern = url.replace(/([\?\*\.\+])/g, '\\$1');
            if (cssText === undefined) {
                continue;
            }

            if (cssText.match('@import[^;]*' + urlForPattern)) {
                var re = new RegExp('@import.*' + urlForPattern + '[^;]*;', 'gi');
                cssText = cssText.replace(re, content);
                style.innerHTML = cssText;
                found = true;
            }
        }
    } else {
        for (i=0; i<links.length; i++) {
            var link = links[i];
            if (i === links.length-1) {
                EVELog.debug('Replacing link with style...');
                style = document.createElement('style');
                style.type = 'text/css';
                style.className = 'evernote-extension';
                style.setAttribute('originalHref', url);
                style.innerHTML = content;
                link.parentElement.replaceChild(style, link);
                found = true;
            } else {
                EVELog.debug('Removing extraneous link: ');
                console.dir(link);
                link.parentElement.removeChild(link);
            }
        }
    }
    if (!found) {
        EVELog.debug('Couldn\'t find references for url: ' + url);
        style = document.createElement('style');
        style.type = 'text/css';
        style.className = 'evernote-extension';
        style.setAttribute('originalHref', url);
        style.innerHTML = content;
        document.head.appendChild(style);
    }
};

EvernoteExtension.prototype.findRemoteSheets = function findRemoteSheets() {
    var urls = [];
    var styleSheets = document.styleSheets;
    if (!styleSheets || styleSheets.length === 0) {
        EVELog.debug('No style sheets found');
        return urls;
    } else {
        for (var i=0; i<styleSheets.length; i++) {
            var sheet = styleSheets[i];
            var media = sheet.media;
            if (media && media.length > 0) {
                var mediaMatches = false;
                for (var m=0; m<media.length; m++) {
                    var mediaMatch = false;
                    var mediaString = media[m];


                    if (mediaString === '' || mediaString == 'all' || mediaString == 'screen') {
                        mediaMatches = true;
                        break;
                    }
                    try {
                        mediaMatch = window.matchMedia(mediaString);
                        if (mediaMatch && mediaMatch.matches) {
                            mediaMatch = true;
                            break;
                        }
                    } catch (e) {
                        EVELog.warn('Error matching media: ' + mediaString);
                    }
                }
                if (!mediaMatches) {
                    EVELog.debug('Skipping sheet because it doesn\'t match media \''+Array.prototype.slice.call(media)+'\' (href:"'+sheet.href+'")');
                    continue;
                }
            }

            var rules = sheet.cssRules;
            if ((!rules || rules.length === 0) && sheet.href) {
                urls.push(sheet.href);
            } else {
                for (var j=0; j<rules.length; j++) {
                    var rule = rules[j];
                    if (rule.constructor == CSSImportRule && rule.href) {
                        urls.push(rule.href);
                    }
                }
            }
        }
    }
    return urls;
};

EvernoteExtension.prototype.isEmptyDocument = function isEmptyDocument() {
    if (!document || !document.body) {
        return true;
    }

    var body = document.body;

    var skipNodes = {
        'SCRIPT': null,
        'NOSCRIPT': null,
        'FRAMESET': null,
        'IFRAME': null,
    };

    // eslint-disable-next-line require-jsdoc
    function filter(node) {
        if (node.nodeType == Node.TEXT_NODE) {
            return NodeFilter.FILTER_ACCEPT;
        }
        var nodeName = node.nodeName;
        if (typeof skipNodes[nodeName] != 'undefined') {
            return NodeFilter.FILTER_REJECT;
        } else if (nodeName == 'IMG') {
            return NodeFilter.FILTER_ACCEPT;
        } else {
            return NodeFilter.FILTER_SKIP;
        }
    }

    var iterator = document.createTreeWalker(body, NodeFilter.SHOW_TEXT + NodeFilter.SHOW_ELEMENT, filter, false);
    var node = null;
    while ((node = iterator.nextNode())) {
        if (node.nodeType == Node.ELEMENT_NODE && node.nodeName == 'IMG') {
            return false;
        } else if (node.nodeType == Node.TEXT_NODE) {
            var txt = node.textContent;
            if (txt) {
                txt = txt.replace(/[ \t\n\r]+/g, '');
            }
            if (txt && txt.length > 0) {
                return false;
            }
        }
    }

    return true;
};

EvernoteExtension.prototype.bodyDidChange = function bodyDidChange(event) {
    var extension = window['extension'];
    extension.bodyLastModified = Date.now();
};

EvernoteExtension.prototype.startDOMChangeTimer = function startDOMChangeTimer() {
    if (this._domChangeTimer) {
        return;
    }
    var body = document.body;
    body.addEventListener('DOMSubtreeModified', this.bodyDidChange, false);
    this._domChangeTimer = true;

    // 手动触发一次, 以兼容 dom 不会继续 变化的 网页. 否则, 外部会因为检测不到变化, 一直等待, 直至超时.
    this.bodyDidChange();
};

EvernoteExtension.prototype.stopDOMChangeTimer = function stopDOMChangeTimer() {
    if (!this._domChangeTimer) {
        return;
    }
    var body = document.body;
    body.removeEventListener('DOMSubtreeModified', this.bodyDidChange, false);
    this._domChangeTimer = false;
};
window.extension = new EvernoteExtension();

if (!Element.prototype._matches) {
    Element.prototype._matches = Element.prototype.matches;
    Element.prototype.matches = function matches(selector) {
        var result = false;
        try {
            result = this._matches(selector);
        } catch (e) {
            EVELog.warn('ERROR matching selector: ' + selector + '; Error: ' + e);
        }
        return result;
    };
}

var dbg = (typeof console !== 'undefined') ? function(s) {
    console.log('Readability: ' + s);
    if (typeof webkit !== 'undefined') {
        window.webkit.messageHandlers.yxloghandler.postMessage({log: s});
    }
} : function() {};
// #endregion

// #region readability
var readability = {
    version: '1.7.1',
    emailSrc: 'http://lab.arc90.com/experiments/readability/email.php',
    iframeLoads: 0,
    convertLinksToFootnotes: false,
    reversePageScroll: false,
    frameHack: false,
    biggestFrame: false,
    bodyCache: null,
    flags: 0x1 | 0x2 | 0x4,
    FLAG_STRIP_UNLIKELYS: 0x1,
    FLAG_WEIGHT_CLASSES: 0x2,
    FLAG_CLEAN_CONDITIONALLY: 0x4,
    maxPages: 30,
    parsedPages: {},
    pageETags: {},
    regexps: {
        unlikelyCandidates: /combx|comment|community|disqus|extra|foot|header|menu|remark|rss|shoutbox|sidebar|sponsor|ad-break|agegate|pagination|pager|popup|tweet|twitter|vjs-modal|weui-desktop|weui-dialog|wx_profile_card|weibo-top|js_album_keep_read|VipRecommendCard|Recommendations-List|MobilePostItem-Description|rich_media_tool/i,
        okMaybeItsACandidate: /and|article|body|column|main|shadow|js_article|htmlbox|page-content|weibo-main|en-note|img-content|Post-Main-Mobile|rich_media_area_primary|rich_media_content/i,
        positive: /article|body|content|entry|hentry|main|page|pagination|post|text|blog|story|page-content|js_article|weibo-main|rich_media_content/i,
        negative: /combx|comment|com-|contact|foot|footer|footnote|masthead|media|meta|outbrain|promo|related|scroll|shoutbox|sidebar|sponsor|shopping|tags|tool|widget/i,
        extraneous: /print|archive|comment|discuss|e[\-]?mail|share|reply|all|login|sign|single/i,
        divToPElements: /<(a|blockquote|dl|div|img|ol|p|pre|table|ul)/i,
        replaceBrs: /(<br[^>]*>[ \n\r\t]*){2,}/gi,
        replaceFonts: /<(\/?)font[^>]*>/gi,
        trim: /^\s+|\s+$/g,
        normalize: /\s{2,}/g,
        killBreaks: /(<br\s*\/?>(\s|&nbsp;?)*){1,}/g,
        videos: /http:\/\/(www\.)?(youtube|vimeo)\.com/i,
        skipFootnoteLink: /^\s*(\[?[a-z0-9]{1,2}\]?|^|edit|citation needed)\s*$/i,
        nextLink: /(next|weiter|continue|>([^|]|$)|Â»([^|]|$))/i,
        prevLink: /(prev|earl|old|new|<|Â«)/i,
        weiboMedia: /weibo-media|m-auto-list/i,
        unlikelyCandidatesForZhihu: /HotQuestionsItem-contain|AnswersNavWrapper|Club-PostComments-Wrapper|PinOIABanner-warpper/i,
        okMaybeItsACandidateForZhihu: /QuestionHeader-richContentGrowth|QuestionHeader-content|PinContentItem-wrap/i,
        positiveForZhihu: /PostItem-content/i,
        nodeReservePattern: /rich_pages|wxw-img/i,
    },
    nodeReservePatternCache: null,
    weChatImagePatternCache: null,
    weChatPlaceHolderPatternCache: null,
    positivePatternCache: null,
    negativePatternCache: null,
    positivePatternForZhihuCache: null,
    readability_class_name: 'readability-styled',
    fixImageFloats: function(articleContent) {
        var imageWidthThreshold = Math.min(articleContent.offsetWidth, 800) * 0.55;
        var images = articleContent.getElementsByTagName('img');

        for (var i=0, il = images.length; i < il; i+=1) {
            var image = images[i];

            if (image.offsetWidth > imageWidthThreshold) {
                image.clasśName += ' blockImage';
            }
        }
    },
    getUnlikelyCandidates: function() {
        if (typeof window.YXJSBridge == 'undefined') {
            dbg('getUnlikelyCandidates YXJSBridge is undefined');
            return this.unlikelyCandidates;
        }

        if (typeof window.YXJSBridge.unlikelyCandidatesPattern === 'undefined') {
            dbg('getUnlikelyCandidates unlikelyCandidatesPattern is undefined');
            return this.unlikelyCandidates;
        }

        dbg('window.YXJSBridge.unlikelyCandidatesPattern is '+ window.YXJSBridge.unlikelyCandidatesPattern());

        return new RegExp(window.YXJSBridge.unlikelyCandidatesPattern(), 'i');
    },
    getUnlikelyCandidatesForZhihu: function() {
        if (typeof window.YXJSBridge == 'undefined') {
            dbg('getUnlikelyCandidatesForZhihu YXJSBridge is undefined');
            return this.unlikelyCandidatesForZhihu;
        }

        if (typeof window.YXJSBridge.unlikelyCandidatesForZhihuPattern === 'undefined') {
            dbg('getUnlikelyCandidatesForZhihu unlikelyCandidatesForZhihuPattern is undefined');
            return this.unlikelyCandidatesForZhihu;
        }

        dbg('window.YXJSBridge.unlikelyCandidatesForZhihuPattern is '+ window.YXJSBridge.unlikelyCandidatesForZhihuPattern());

        return new RegExp(window.YXJSBridge.unlikelyCandidatesForZhihuPattern(), 'i');
    },
    getOkMaybeItsACandidates: function() {
        if (typeof window.YXJSBridge == 'undefined') {
            dbg('getOkMaybeItsACandidates YXJSBridge is undefined');
            return this.okMaybeItsACandidate;
        }

        if (typeof window.YXJSBridge.okMaybeItsACandidatePattern === 'undefined') {
            dbg('getOkMaybeItsACandidates okMaybeItsACandidatePattern is undefined');
            return this.okMaybeItsACandidate;
        }

        dbg('window.YXJSBridge.okMaybeItsACandidatePattern is '+ window.YXJSBridge.okMaybeItsACandidatePattern());

        return new RegExp(window.YXJSBridge.okMaybeItsACandidatePattern(), 'i');
    },
    getOkMaybeItsACandidateForZhihu: function() {
        if (typeof window.YXJSBridge == 'undefined') {
            dbg('getOkMaybeItsACandidateForZhihu YXJSBridge is undefined');
            return this.okMaybeItsACandidateForZhihu;
        }

        if (typeof window.YXJSBridge.okMaybeItsACandidateForZhihuPattern === 'undefined') {
            dbg('getOkMaybeItsACandidateForZhihu okMaybeItsACandidatePattern is undefined');
            return this.okMaybeItsACandidateForZhihu;
        }

        dbg('window.YXJSBridge.okMaybeItsACandidateForZhihuPattern is '+ window.YXJSBridge.okMaybeItsACandidateForZhihuPattern());

        return new RegExp(window.YXJSBridge.okMaybeItsACandidateForZhihuPattern(), 'i');
    },
    getPositivePattern: function() {
        if (this.positivePatternCache !== null) {
            return this.positivePatternCache;
        }

        if (typeof window.YXJSBridge == 'undefined') {
            dbg('getPositivePattern YXJSBridge is undefined');
            return this.positive;
        }

        if (typeof window.YXJSBridge.positivePattern === 'undefined') {
            dbg('getPositivePattern positivePattern is undefined');
            return this.positive;
        }

        dbg('window.YXJSBridge.positivePattern is '+ window.YXJSBridge.positivePattern());

        var pattern = new RegExp(window.YXJSBridge.positivePattern(), 'i');
        this.positivePatternCache = pattern;
        return pattern;
    },
    getPositiveForZhihuPattern: function() {
        if (this.positivePatternForZhihuCache !== null) {
            return this.positivePatternForZhihuCache;
        }

        if (typeof window.YXJSBridge == 'undefined') {
            dbg('getpositiveForZhihuPattern YXJSBridge is undefined');
            return this.positiveForZhihu;
        }

        if (typeof window.YXJSBridge.positiveForZhihuPattern === 'undefined') {
            dbg('getpositiveForZhihuPattern positivePattern is undefined');
            return this.positiveForZhihu;
        }

        dbg('window.YXJSBridge.positiveForZhihuPattern is '+ window.YXJSBridge.positiveForZhihuPattern());

        var pattern = new RegExp(window.YXJSBridge.positiveForZhihuPattern(), 'i');
        this.positivePatternForZhihuCache = pattern;
        return pattern;
    },
    getNegativePattern: function() {
        if (this.negativePatternCache !== null) {
            return this.negativePatternCache;
        }

        if (typeof window.YXJSBridge == 'undefined') {
            dbg('getNegativePattern YXJSBridge is undefined');
            return this.negative;
        }

        if (typeof window.YXJSBridge.negativePattern === 'undefined') {
            dbg('getNegativePattern negativePattern is undefined');
            return this.negative;
        }

        dbg('window.YXJSBridge.negativePattern is '+ window.YXJSBridge.negativePattern());

        var pattern = new RegExp(window.YXJSBridge.negativePattern(), 'i');
        this.negativePatternCache = pattern;
        return pattern;
    },
    isImageElement: function(e) {
        return e instanceof HTMLImageElement;
    },
    isWechatImage: function(e) {
        var weChatImagePattern = this.weChatImagePatternCache;
        if (weChatImagePattern == null) {
            dbg('weChatImagePattern is null, apollo wechatIamgePattern is ' + window.YXJSBridge.weChatImagePattern());
            try {
                weChatImagePattern = new RegExp(window.YXJSBridge.weChatImagePattern(), 'i');
            } catch (error) {
                dbg(error.toString());
                weChatImagePattern = /rich_pages|wxw-img/i;
            }
            this.weChatImagePatternCache = weChatImagePattern;
        }
        // dbg("weChatImagePattern is "+ weChatImagePattern);
        try {
            dbg('isWeChatImage start search');
            var isWeChatImage = e.className.search(weChatImagePattern) !== -1;
            if (!isWeChatImage) {
                dbg('failed to check if wechat img with pattern: '+weChatImagePattern);
                var imgAttrs = [];
                if(window.YXJSBridge.platform() === EvernoteExtension.prototype.PLATFORM_ANDROID) {
                    dbg('process android wechatImageAttributes');
                    imgAttrs = JSON.parse(window.YXJSBridge.wechatImageAttributes());
                } else {
                    imgAttrs = window.YXJSBridge.wechatImageAttributes();
                }
                dbg('wechat image attributes:'+imgAttrs);
                isWeChatImage = true;
                for (var i = 0; i < imgAttrs.length; i++) {
                    var attr = imgAttrs[i];
                    if (!e.hasAttribute(attr)) {
                        dbg('e doesnt have attribute: '+ attr);
                        isWeChatImage = false;
                        break;
                    }
                }
            }
            return isWeChatImage;
        } catch (error) {
            dbg(error.toString());
            return false;
        }
    },
    shouldReserveNode: function(e) {
        if (this.isWechatImage(e)) {
            return true;
        }
        var reservePattern = this.nodeReservePatternCache;
        if (reservePattern == null) {
            dbg('nodeReservePatternCache is null, apollo nodeReservePattern is ' + window.YXJSBridge.nodeReservePattern());
            try {
                reservePattern = new RegExp(window.YXJSBridge.nodeReservePattern(), 'i');
            } catch (error) {
                dbg(error.toString());
                reservePattern = this.nodeReservePattern;
            }
            this.nodeReservePatternCache = reservePattern;
        }
        try {
            dbg('shouldReserveNode start search');
            return e.className.search(reservePattern) !== -1;
        } catch (error) {
            dbg(error.toString());
            return false;
        }
    },
    isWeChatPlaceHolder(e) {
        var pattern = this.weChatPlaceHolderPatternCache;
        if (pattern == null) {
            dbg('weChatPlaceHolderPatternCache is null, apolloweChatPlaceHolderPattern is  ' + window.YXJSBridge.weChatPlaceHolderPattern());
            try {
                pattern = new RegExp(window.YXJSBridge.weChatPlaceHolderPattern(), 'i');
            } catch (error) {
                dbg(error.toString());
                pattern = /js_img_placeholder|wx_widget_placeholder/i;
            }
            this.weChatPlaceHolderPatternCache = pattern;
        }
        // dbg("weChatPlaceHolderPatternCache is "+ pattern);
        try {
            return e.className.search(pattern) !== -1;
        } catch (error) {
            dbg(error.toString());
            return false;
        }
    },
    getSuggestedDirection: function(text) {
        function sanitizeText() {
            return text.replace(/@\w+/, '');
        }

        function countMatches(match) {
            var matches = text.match(new RegExp(match, 'g'));
            return matches !== null ? matches.length : 0;
        }

        function isRTL() {
            var count_heb = countMatches('[\\u05B0-\\u05F4\\uFB1D-\\uFBF4]');
            var count_arb = countMatches('[\\u060C-\\u06FE\\uFB50-\\uFEFC]');
            return (count_heb + count_arb) * 100 / text.length > 20;
        }

        text = sanitizeText(text);
        return isRTL() ? 'rtl' : 'ltr';
    },

    getArticleTitle: function(doc) {
        var curTitle = '';
        try {
            if (doc === null) {
                doc = document;
            }
            curTitle = doc.title;
            if (typeof curTitle === 'undefined' || curTitle === '') {
                curTitle = readability.getInnerText(doc.getElementsByTagName('title')[0]);
            }
        } catch (e) {
            EVELog.debug(e.toString());
        }

        return curTitle;
    },
    isShitang: function() {
        var regex = /yinxiang.com\/everhub\/note/i;
        return window.location.href.search(regex) !== -1;
    },
    isWeChatArticle: function() {
        var regex = /mp.weixin.qq.com/i;
        return this.isSpecificHost(regex);
    },
    isRenmin: function() {
        var regex = /wap.peopleapp.com/i;
        return this.isSpecificHost(regex);
    },
    isWeibo: function() {
        var regex = /m.weibo/i;
        return this.isSpecificHost(regex);
    },
    isTouTiao: function() {
        var regex = /m.toutiao.com/i;
        return this.isSpecificHost(regex);
    },
    isZhihu: function() {
        var regex = /zhihu.com/i;
        return this.isSpecificHost(regex);
    },
    isBaiduNews: function() {
        var regex = /mbd.baidu.com/i;
        return this.isSpecificHost(regex);
    },
    isXuexiQiangGuo: function() {
        var regex = /article.xuexi.cn/i;
        return this.isSpecificHost(regex);
    },
    isDouyin: function() {
        var regex = /douyin.com/i;
        return this.isSpecificHost(regex);
    },
    isXiaohongshu: function() {
        var regex = /xiaohongshu.com/i;
        return this.isSpecificHost(regex);
    },
    isBilibili: function() {
        var regex = /m.bilibili.com/i;
        return this.isSpecificHost(regex);
    },
    isSpecificHost: function(regex) {
        var host = window.location.host;
        return host.search(regex) !== -1;
    },
    isSpecificHost: function(regex) {
        var host = window.location.host;
        return host.search(regex) !== -1;
    },
    prepArticle: function(articleContent) {
        readability.processImages(articleContent);
        // readability.cleanStyles(articleContent);
        readability.killBreaks(articleContent);

        readability.cleanConditionally(articleContent, 'form');
        readability.clean(articleContent, 'object');
        // readability.clean(articleContent, "h1");


        if (articleContent.getElementsByTagName('h2').length === 1) {
            readability.clean(articleContent, 'h2');
        }
        readability.clean(articleContent, 'iframe');

        readability.cleanHeaders(articleContent);

        dbg('cleanConditionally - table');
        readability.cleanConditionally(articleContent, 'table');

        if (!readability.isWeibo()) {
            dbg('cleanConditionally - ul');
            readability.cleanConditionally(articleContent, 'ul');
            if (!readability.isWeChatArticle()) {
                dbg('cleanConditionally - div');
                readability.cleanConditionally(articleContent, 'div');
            }
        }

        var articleParagraphs = articleContent.getElementsByTagName('p');
        for (var i = articleParagraphs.length-1; i >= 0; i-=1) {
            var imgCount = articleParagraphs[i].getElementsByTagName('img').length;
            var embedCount = articleParagraphs[i].getElementsByTagName('embed').length;
            var objectCount = articleParagraphs[i].getElementsByTagName('object').length;

            if (imgCount === 0 && embedCount === 0 && objectCount === 0 && readability.getInnerText(articleParagraphs[i], false) === '') {
                articleParagraphs[i].parentNode.removeChild(articleParagraphs[i]);
            }
        }

        try {
            articleContent.innerHTML = articleContent.innerHTML.replace(/<br[^>]*>\s*<p/gi, '<p');
        } catch (e) {
            dbg('Cleaning innerHTML of breaks failed. This is an IE strict-block-elements bug. Ignoring.: ' + e);
        }
    },


    initializeNode: function(node) {
        node.readability = {'contentScore': 0};

        switch (node.tagName) {
        case 'DIV':
            node.readability.contentScore += 5;
            break;

        case 'PRE':
        case 'TD':
        case 'BLOCKQUOTE':
            node.readability.contentScore += 3;
            break;

        case 'ADDRESS':
        case 'OL':
        case 'UL':
        case 'DL':
        case 'DD':
        case 'DT':
        case 'LI':
        case 'FORM':
            node.readability.contentScore -= 3;
            break;

        case 'H1':
        case 'H2':
        case 'H3':
        case 'H4':
        case 'H5':
        case 'H6':
        case 'TH':
            node.readability.contentScore -= 5;
            break;
        }

        node.readability.contentScore += readability.getClassWeight(node);
    },


    grabArticle: function(page) {
        var stripUnlikelyCandidates = readability.flagIsActive(readability.FLAG_STRIP_UNLIKELYS);
        var isPaging = (page !== null) ? true: false;

        page = page ? page : document.body;

        var pageCacheHtml = page.innerHTML;

        var allElements = page.getElementsByTagName('*');


        var node = null;
        var nodesToScore = [];
        var unlikelyCandidatesPattern = readability.getUnlikelyCandidates();
        var okMaybeItsACandidatePattern = readability.getOkMaybeItsACandidates();
        var unlikelyCandidatesForZhihuPattern = readability.getUnlikelyCandidatesForZhihu();
        var okMaybeItsACandidateForZhihuPattern = readability.getOkMaybeItsACandidateForZhihu();
        for (var nodeIndex = 0; (node = allElements[nodeIndex]); nodeIndex+=1) {
            if (stripUnlikelyCandidates) {
                var unlikelyMatchString = node.className +':'+ node.id;
                if (
                    (
                        unlikelyMatchString.search(unlikelyCandidatesPattern) !== -1 &&
                     unlikelyMatchString.search(okMaybeItsACandidatePattern) === -1 &&
                     node.tagName !== 'BODY'
                    )
                ) {
                    if (readability.isZhihu() &&
                        unlikelyMatchString.search(okMaybeItsACandidateForZhihuPattern) !== -1) {
                        dbg('Stop Removing unlikely candidate for zhihu- ' + unlikelyMatchString);
                        continue;
                    }

                    dbg('Removing unlikely candidate - ' + unlikelyMatchString);
                    node.parentNode.removeChild(node);
                    nodeIndex-=1;
                    continue;
                } else if (readability.isZhihu() && unlikelyMatchString.search(unlikelyCandidatesForZhihuPattern) !== -1) {
                    dbg('Removing unlikely candidate for zhihu- ' + unlikelyMatchString);
                    node.parentNode.removeChild(node);
                    nodeIndex-=1;
                    continue;
                }
            }

            if (node.tagName === 'P' || node.tagName === 'TD' || node.tagName === 'PRE') {
                nodesToScore[nodesToScore.length] = node;
            } else if (node.tagName === 'SPAN') {
                if (node.childNodes.length === 1 && node.childNodes[0].nodeType === 3) {
                    nodesToScore[nodesToScore.length] = node;
                } else {
                    var innerText = readability.getInnerText(node);
                    if (innerText.length > 10) {
                        nodesToScore[nodesToScore.length] = node;
                    }
                }
            }


            if (node.tagName === 'DIV') {
                if (node.innerHTML.search(readability.regexps.divToPElements) === -1) {
                    var newNode = document.createElement('p');
                    try {
                        newNode.innerHTML = node.innerHTML;
                        node.parentNode.replaceChild(newNode, node);
                        nodeIndex-=1;

                        nodesToScore[nodesToScore.length] = node;
                    } catch (e) {
                        dbg('Could not alter div to p, probably an IE restriction, reverting back to div.: ' + e);
                    }
                } else {
                    for (var i = 0, il = node.childNodes.length; i < il; i+=1) {
                        var childNode = node.childNodes[i];
                        if (childNode.nodeType === 3) {
                            var p = document.createElement('p');
                            p.innerHTML = childNode.nodeValue;
                            p.style.display = 'inline';
                            p.className = readability.readability_class_name;
                            childNode.parentNode.replaceChild(p, childNode);
                        }
                    }
                }
            }
        }


        var candidates = [];
        for (var pt=0; pt < nodesToScore.length; pt+=1) {
            var parentNode = nodesToScore[pt].parentNode;
            var grandParentNode = parentNode ? parentNode.parentNode : null;
            while (grandParentNode != null && grandParentNode.tagName !== 'DIV') {
                grandParentNode = grandParentNode.parentNode;
            }

            if (!grandParentNode) {
                grandParentNode = parentNode ? parentNode.parentNode : null;
            }

            if (nodesToScore[pt].className === readability.readability_class_name && readability.isWeibo() && grandParentNode != null) {
                parentNode = grandParentNode;
            }

            var innerText = readability.getInnerText(nodesToScore[pt]);

            if (!parentNode || typeof(parentNode.tagName) === 'undefined') {
                continue;
            }

            if (innerText.length < 15) {
                continue;
            }

            // var parentNodeId = parentNode.className +":"+ parentNode.id;
            // dbg("parentNodeId - " + parentNodeId);
            // if(grandParentNode) {
            //   var grandParentNodeId = grandParentNode.className +":"+ grandParentNode.id;
            //   dbg("grandParentNodeId - " + grandParentNodeId);
            // }
            // var nodeId = nodesToScore[pt].className +":"+ nodesToScore[pt].id;
            // dbg("nodeId - " + nodeId);

            if (typeof parentNode.readability === 'undefined') {
                readability.initializeNode(parentNode);
                candidates.push(parentNode);
            }


            if (grandParentNode && typeof(grandParentNode.readability) === 'undefined' && typeof(grandParentNode.tagName) !== 'undefined') {
                readability.initializeNode(grandParentNode);
                candidates.push(grandParentNode);
            }

            var contentScore = 0;


            contentScore+=1;
            var indexOfComma = innerText.indexOf(',');
            if (indexOfComma !== -1) {
                contentScore += innerText.split(',').length;
            } else {
                contentScore += innerText.split('，').length;
            }

            contentScore += Math.min(Math.floor(innerText.length / 100), 3);


            parentNode.readability.contentScore += contentScore;
            if (grandParentNode) {
                grandParentNode.readability.contentScore += contentScore/2;
            }
        }

        var topCandidate = null;
        for (var c=0, cl=candidates.length; c < cl; c+=1) {
            candidates[c].readability.contentScore = candidates[c].readability.contentScore * (1-readability.getLinkDensity(candidates[c]));

            dbg('Candidate: ' + candidates[c] + ' (' + candidates[c].className + ':' + candidates[c].id + ') with score ' + candidates[c].readability.contentScore + ', tagName='+candidates[c].tagName);

            if (!topCandidate || candidates[c].readability.contentScore > topCandidate.readability.contentScore) {
                topCandidate = candidates[c];
            }
        }

        if (topCandidate) {
            dbg('topCandidate '+ '('+topCandidate.className+':'+topCandidate.id+')');
        }

        if (topCandidate === null || topCandidate.tagName === 'BODY') {
            topCandidate = document.createElement('DIV');
            topCandidate.innerHTML = page.innerHTML;
            page.innerHTML = '';
            page.appendChild(topCandidate);
            readability.initializeNode(topCandidate);
        }

        dbg('topCandidate '+ '('+topCandidate.className+':'+topCandidate.id+')');

        var articleContent = document.createElement('DIV');
        if (isPaging) {
            articleContent.id = 'readability-content';
        }
        var siblingScoreThreshold = Math.max(10, topCandidate.readability.contentScore * 0.2);
        var siblingNodes = topCandidate.parentNode.childNodes;


        for (var s=0, sl=siblingNodes.length; s < sl; s+=1) {
            var siblingNode = siblingNodes[s];
            var append = false;


            if (!siblingNode) {
                continue;
            }

            dbg('Looking at sibling node: ' + siblingNode + ' (' + siblingNode.className + ':' + siblingNode.id + ')' + ((typeof siblingNode.readability !== 'undefined') ? (' with score ' + siblingNode.readability.contentScore) : ''));
            dbg('Sibling has score ' + (siblingNode.readability ? siblingNode.readability.contentScore : 'Unknown'));

            if (siblingNode === topCandidate) {
                append = true;
            }

            var contentBonus = 0;

            if (siblingNode.className === topCandidate.className && topCandidate.className !== '') {
                contentBonus += topCandidate.readability.contentScore * 0.2;
            }

            if (typeof siblingNode.readability !== 'undefined' && (siblingNode.readability.contentScore+contentBonus) >= siblingScoreThreshold) {
                append = true;
            }

            if (siblingNode.nodeName === 'P') {
                var linkDensity = readability.getLinkDensity(siblingNode);
                var nodeContent = readability.getInnerText(siblingNode);
                var nodeLength = nodeContent.length;

                if (nodeLength > 80 && linkDensity < 0.25) {
                    append = true;
                } else if (nodeLength < 80 && linkDensity === 0 && nodeContent.search(/\.( |$)/) !== -1) {
                    append = true;
                }
            }

            if (append) {
                dbg('Appending node: ' + siblingNode);

                var nodeToAppend = null;
                if (siblingNode.nodeName !== 'DIV' && siblingNode.nodeName !== 'P') {
                    dbg('Altering siblingNode of ' + siblingNode.nodeName + ' to div.');
                    nodeToAppend = document.createElement('DIV');
                    try {
                        nodeToAppend.id = siblingNode.id;
                        nodeToAppend.innerHTML = siblingNode.innerHTML;
                    } catch (er) {
                        dbg('Could not alter siblingNode to div, probably an IE restriction, reverting back to original.');
                        nodeToAppend = siblingNode;
                        s-=1;
                        sl-=1;
                    }
                } else {
                    nodeToAppend = siblingNode;
                    s-=1;
                    sl-=1;
                }


                nodeToAppend.className = '';


                articleContent.appendChild(nodeToAppend);
            }
        }
        // dbg('articleContent ' + articleContent.outerHTML);
        readability.prepArticle(articleContent);
        // dbg('articleContent after prep' + articleContent.outerHTML);

        if (readability.getInnerText(articleContent, false).length < 25 && !readability.isWeibo()) {
            page.innerHTML = pageCacheHtml;

            if (readability.flagIsActive(readability.FLAG_STRIP_UNLIKELYS)) {
                dbg('FLAG_STRIP_UNLIKELYS');
                readability.removeFlag(readability.FLAG_STRIP_UNLIKELYS);
                return readability.grabArticle(page);
            } else if (readability.flagIsActive(readability.FLAG_WEIGHT_CLASSES)) {
                dbg('FLAG_WEIGHT_CLASSES');
                readability.removeFlag(readability.FLAG_WEIGHT_CLASSES);
                return readability.grabArticle(page);
            } else if (readability.flagIsActive(readability.FLAG_CLEAN_CONDITIONALLY)) {
                dbg('FLAG_CLEAN_CONDITIONALLY');
                readability.removeFlag(readability.FLAG_CLEAN_CONDITIONALLY);
                return readability.grabArticle(page);
            } else {
                return null;
            }
        }

        return articleContent;
    },

    getInnerText: function(e, normalizeSpaces) {
        var textContent = '';

        if (typeof(e.textContent) === 'undefined' && typeof(e.innerText) === 'undefined') {
            return '';
        }

        normalizeSpaces = (typeof normalizeSpaces === 'undefined') ? true : normalizeSpaces;

        if (navigator.appName === 'Microsoft Internet Explorer') {
            textContent = e.innerText.replace( readability.regexps.trim, '' );
        } else {
            textContent = e.textContent.replace( readability.regexps.trim, '' );
        }

        if (normalizeSpaces) {
            return textContent.replace( readability.regexps.normalize, ' ');
        } else {
            return textContent;
        }
    },

    getCharCount: function(e, s) {
        s = s || ',';
        return readability.getInnerText(e).split(s).length-1;
    },


    cleanStyles: function(e) {
        e = e || document;
        var cur = e.firstChild;

        if (!e) {
            return;
        }


        if (typeof e.removeAttribute === 'function' && e.className !== 'readability-styled') {
            e.removeAttribute('style');
        }

        while ( cur !== null ) {
            if ( cur.nodeType === 1 ) {
                if (cur.className !== 'readability-styled') {
                    cur.removeAttribute('style');
                }
                readability.cleanStyles( cur );
            }
            cur = cur.nextSibling;
        }
    },
    processImages: function(e) {
        // Where el is the DOM element you'd like to test for visibility
        // eslint-disable-next-line require-jsdoc
        function isHidden(el) {
            if (el.style.display === 'none') {
                return true;
            }
            var style = window.getComputedStyle(el);
            return (style.display === 'none');
        }

        if (!e) {
            return;
        }

        var imgs = e.querySelectorAll('img');
        dbg('------------processImages--------------,images:'+imgs.length);
        for (var i = 0; i < imgs.length; i++) {
            var element = imgs[i];
            if (this.isWechatImage(element) && isHidden(element)) {
                dbg('------------display wechat hidden image--------------');
                element.style.display = 'block';
            }
            continue;

            // dbg("processImages looking at: " + element.src);
            if (isHidden(element)) {
                dbg('node is hidden: ' + element.className);
                element.parentNode.removeChild(element);
            }
        }
    },
    getLinkDensity: function(e) {
        var links = e.getElementsByTagName('a');
        var textLength = readability.getInnerText(e).length;
        var linkLength = 0;
        for (var i=0, il=links.length; i<il; i+=1) {
            linkLength += readability.getInnerText(links[i]).length;
        }

        return linkLength / textLength;
    },

    getClassWeight: function(e) {
        if (!readability.flagIsActive(readability.FLAG_WEIGHT_CLASSES)) {
            return 0;
        }

        var weight = 0;


        if (typeof(e.className) === 'string' && e.className !== '') {
            if (e.className.search(readability.getNegativePattern()) !== -1) {
                weight -= 25;
            }

            if (e.className.search(readability.getPositivePattern()) !== -1 || (readability.isZhihu() && e.className.search(readability.getPositiveForZhihuPattern()) !== -1)) {
                weight += 25;
            }
        }


        if (typeof(e.id) === 'string' && e.id !== '') {
            if (e.id.search(readability.getNegativePattern()) !== -1) {
                weight -= 25;
            }

            if (e.id.search(readability.getPositivePattern()) !== -1) {
                weight += 25;
            }
        }

        return weight;
    },

    nodeIsVisible: function(node) {
        return node.style.display.toLowerCase() !== 'none';
    },


    killBreaks: function(e) {
        try {
            e.innerHTML = e.innerHTML.replace(readability.regexps.killBreaks, '<br />');
        } catch (eBreaks) {
            dbg('KillBreaks failed - this is an IE bug. Ignoring.: ' + eBreaks);
        }
    },
    clean: function(e, tag) {
        var targetList = e.getElementsByTagName( tag );
        var isEmbed = (tag === 'object' || tag === 'embed');

        for (var y=targetList.length-1; y >= 0; y-=1) {
            if (isEmbed) {
                var attributeValues = '';
                for (var i=0, il=targetList[y].attributes.length; i < il; i+=1) {
                    attributeValues += targetList[y].attributes[i].value + '|';
                }


                if (attributeValues.search(readability.regexps.videos) !== -1) {
                    continue;
                }


                if (targetList[y].innerHTML.search(readability.regexps.videos) !== -1) {
                    continue;
                }
            }

            targetList[y].parentNode.removeChild(targetList[y]);
        }
    },
    cleanConditionally: function(e, tag) {
        if (!readability.flagIsActive(readability.FLAG_CLEAN_CONDITIONALLY)) {
            return;
        }

        var tagsList = e.getElementsByTagName(tag);
        var curTagsLength = tagsList.length;


        for (var i=curTagsLength-1; i >= 0; i-=1) {
            var weight = readability.getClassWeight(tagsList[i]);
            var contentScore = (typeof tagsList[i].readability !== 'undefined') ? tagsList[i].readability.contentScore : 0;
            var matchString = tagsList[i].className +':'+ tagsList[i].id;
            if (matchString.search(readability.regexps.weiboMedia) !== -1) {
                continue;
            }

            dbg('Cleaning Conditionally ' + tagsList[i] + ' (' + tagsList[i].className + ':' + tagsList[i].id + ')' + ((typeof tagsList[i].readability !== 'undefined') ? (' with score ' + tagsList[i].readability.contentScore) : ''));

            if (weight+contentScore < 0) {
                dbg('removed due to weight+contentScore is less than 0.');
                tagsList[i].parentNode.removeChild(tagsList[i]);
            } else if ( readability.getCharCount(tagsList[i], ',') < 10) {
                var p = tagsList[i].getElementsByTagName('p').length;
                var img = tagsList[i].getElementsByTagName('img').length;
                var li = tagsList[i].getElementsByTagName('li').length-100;
                var input = tagsList[i].getElementsByTagName('input').length;

                var embedCount = 0;
                var embeds = tagsList[i].getElementsByTagName('embed');
                for (var ei=0, il=embeds.length; ei < il; ei+=1) {
                    if (embeds[ei].src.search(readability.regexps.videos) === -1) {
                        embedCount+=1;
                    }
                }

                var linkDensity = readability.getLinkDensity(tagsList[i]);
                var contentLength = readability.getInnerText(tagsList[i]).length;
                var toRemove = false;

                if (li > p && tag !== 'ul' && tag !== 'ol') {
                    dbg('removed due to li > p && tag !== "ul" && tag !== "ol"');
                    toRemove = true;
                } else if ( input > Math.floor(p/3) ) {
                    dbg('removed due to input > Math.floor(p/3).');
                    toRemove = true;
                } else if (contentLength < 25 && (img === 0 || img > 2) ) {
                    dbg('removed due to contentLength < 5 && (img === 0 || img > 2');
                    if (!this.isShitang()) {
                        toRemove = true;
                    }
                } else if (weight < 25 && linkDensity > 0.2) {
                    if (location.href.search(/zhihu.com\/pin/i) === -1) {
                        dbg('removed due to weight < 5 && linkDensity > 0.2.');
                        toRemove = true;
                    }
                } else if (weight >= 25 && linkDensity > 0.5) {
                    dbg('removed due to weight >= 5 && linkDensity > 0.5');
                    toRemove = true;
                } else if ((embedCount === 1 && contentLength < 75) || embedCount > 1) {
                    toRemove = true;
                    dbg('removed due to (embedCount === 1 && contentLength < 75) || embedCount > 1');
                }

                if (toRemove) {
                    tagsList[i].parentNode.removeChild(tagsList[i]);
                }
            }
        }
    },
    clickExpandable: function() {
        var xpaths = ['//*[text()=\'展开\']', '//*[text()=\'展开剩余\']', '//*[text()=\'展开阅读全文\']'];
        for (var i = 0; i < xpaths.length; i++) {
            var xpath = xpaths[i];
            var matchingElement = document.evaluate(xpath, document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
            if (matchingElement != null) {
                matchingElement.click();
            }
        }
    },
    getVideoSource: function(e) {
        // 获取视频src
        var sources = [];
        var videos = e.querySelectorAll('video');
        for (var i=0; i<videos.length; i++) {
            var video = videos[i];
            var src = video.getAttribute('src');
            if (src != null) {
                sources.push(src);
            }
        }
        return sources;
    },
    getSiteName: function() {
        var type = 'other';
        if (readability.isDouyin()) {
            type = 'douyin';
        } else if (readability.isXiaohongshu()) {
            type = 'xiaohongshu';
        } else if (readability.isBilibili()) {
            type = 'bilibili';
        }
        return type;
    },
    /**
     * 是否该image可以做瀑布流的卡片Cover
     * @param {object} image 图片实例.
     * @returns {boolean} true or false.
     */
    isValidCoverImage: function(image) {
        var width = image.naturalWidth;
        var height = image.naturalHeight;

        var filterCoverWidth = 252;
        var filterCoverHeight = 189;

        try {
            filterCoverWidth = window.YXJSBridge.coverWidth();
            filterCoverHeight = window.YXJSBridge.coverHeight();
        } catch (error) {
            dbg(error.toString());
        }

        EVELog.debug('isValidCoverImage Width: ' + width + ', height:' + height);

        if (width < filterCoverWidth || height < filterCoverHeight) {
            return false;
        }
        return true;
    },
    isImageLoaded: function(image) {
        return image.complete && image.naturalHeight !== 0;
    },
    cleanHeaders: function(e) {
        for (var headerIndex = 1; headerIndex < 3; headerIndex+=1) {
            var headers = e.getElementsByTagName('h' + headerIndex);
            for (var i=headers.length-1; i >=0; i-=1) {
                if (readability.getClassWeight(headers[i]) < 0 || readability.getLinkDensity(headers[i]) > 0.33) {
                    headers[i].parentNode.removeChild(headers[i]);
                }
            }
        }
    },
    htmlspecialchars: function(s) {
        if (typeof(s) === 'string') {
            s = s.replace(/&/g, '&amp;');
            s = s.replace(/"/g, '&quot;');
            s = s.replace(/'/g, '&#039;');
            s = s.replace(/</g, '&lt;');
            s = s.replace(/>/g, '&gt;');
        }

        return s;
    },

    flagIsActive: function(flag) {
        return (readability.flags & flag) > 0;
    },

    addFlag: function(flag) {
        readability.flags = readability.flags | flag;
    },

    removeFlag: function(flag) {
        readability.flags = readability.flags & ~flag;
    },
};
// #endregion
