/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "./";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./3rdParty/clipperCore/src/serializer/BrowserFrameLoader.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./3rdParty/clipperCore/src/serializer/BrowserFrameLoader.js":
/*!*******************************************************************!*\
  !*** ./3rdParty/clipperCore/src/serializer/BrowserFrameLoader.js ***!
  \*******************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _FrameChannel = __webpack_require__(/*! ../utilities/FrameChannel */ "./3rdParty/clipperCore/src/utilities/FrameChannel.js");

var _FrameChannel2 = _interopRequireDefault(_FrameChannel);

var _Types = __webpack_require__(/*! ../types/Types */ "./3rdParty/clipperCore/src/types/Types.js");

var _selectionUtils = __webpack_require__(/*! ../utilities/selectionUtils */ "./3rdParty/clipperCore/src/utilities/selectionUtils.js");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const TIMEOUT_SCRIPT_INSTALLATION = 2000; //
//  BrowserFrameLoader.js
//  WebClipper
//
//  Created by zlosvik on 07/02/2017.
//  Copyright © 2017 Evernote Corporation. All rights reserved.
//
//  This file needs to be injected into every frame of a web page in a browser.
//
//  When instructed this loader will recursively load FrameSerializer.js into every frame.
//

const allowedScripts = {
  frameSerializer: ''
};

class BrowserFrameLoader {
  constructor() {
    this._completed = false;
    this._timeoutID = null;
    this._frameChannel = new _FrameChannel2.default('BrowserFrameLoader', {
      [_Types.MessageNames.INSTALL_SERIALIZER]: msg => this.installAllFrameSerializers(msg),
      [_Types.MessageNames.INSTALL_AND_SERIALIZE_ALL]: msg => this.installAndSerializeAll(msg),
      [_Types.MessageNames.INSTALL_AND_SERIALIZE_TO]: msg => this.installAndSerizalizeTo(msg)
    });
    if (chrome && chrome.runtime && chrome.runtime.getURL && typeof chrome.runtime.getURL === 'function') {
      allowedScripts.frameSerializer = chrome.runtime.getURL('FrameSerializer.js');
    }
  }

  start() {
    this._frameChannel.start();
  }

  stop() {
    this._frameChannel.stop();
  }

  installAndSerizalizeTo({ frameName }) {
    const frame = document.querySelector(`.${frameName}`);
    return this._frameChannel.sendMessageToFrame(frame, _Types.MessageNames.INSTALL_SERIALIZER).catch(e => {
      // eslint-disable-next-line no-console
      console.warn(e);
    }).then(() => this._frameChannel.sendMessageToFrame(frame, _Types.MessageNames.SERIALIZE));
  }

  installAndSerializeAll({ target, rangeInfo = null }) {
    this._completed = false;
    const range = (0, _selectionUtils.createRange)(JSON.parse(rangeInfo));
    return new Promise(resolve => {
      const _complete = () => {
        if (this._completed) {
          return;
        }
        this._completed = true;
        window.clearTimeout(this._timeoutID);
        resolve(this._frameChannel.sendMessage(window, _Types.MessageNames.SERIALIZE, { target, rangeInfo }));
      };

      this._timeoutID = window.setTimeout(() => {
        _complete();
      }, TIMEOUT_SCRIPT_INSTALLATION);

      this.installAllFrameSerializers({ target, range }).then(() => {
        _complete();
      });
    });
  }

  installAllFrameSerializers({ target, range }) {
    return Promise.all([this._installScript('frameSerializer'), this._installChildFrameSerializers({ target, range })]);
  }

  _installChildFrameSerializers({ target, range }) {
    const container = document.querySelector(target) || document;
    return new Promise(resolve => {
      let frames = [].slice.apply(container.querySelectorAll(`iframe:not(.${_Types.SERIALIZER_IGNORED_CLASS})`));
      if (range) {
        frames = frames.filter(item => range.intersectsNode(item));
      }
      if (!frames.length) {
        resolve();
      }
      const promises = [];
      frames.forEach(frame => {
        promises.push(this._frameChannel.sendMessageToFrame(frame, _Types.MessageNames.INSTALL_SERIALIZER));
      });
      Promise.all(promises).then(resolve);
      setTimeout(resolve, TIMEOUT_SCRIPT_INSTALLATION);
    });
  }

  _installScript(name) {
    return new Promise((resolve, reject) => {
      if (!allowedScripts[name]) {
        resolve();
      }
      if (document.querySelector(`script[src='${allowedScripts[name]}']`)) {
        resolve();
        return;
      }
      const script = document.createElement('script');
      script.type = 'text/javascript';
      script.src = allowedScripts[name];
      script.onload = () => {
        resolve();
      };
      script.onerror = () => {
        reject(new Error(`Failed to load script: "${allowedScripts[name]}"`));
      };
      document.head.appendChild(script);
    });
  }
}

const frameLoader = new BrowserFrameLoader();
frameLoader.start();

/***/ }),

/***/ "./3rdParty/clipperCore/src/types/Types.js":
/*!*************************************************!*\
  !*** ./3rdParty/clipperCore/src/types/Types.js ***!
  \*************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
//
//  Types.js
//  WebClipper
//
//  Created by zlosvik on 13/02/2017.
//  Copyright © 2017 Evernote Corporation. All rights reserved.
//

const SERIALIZER_IGNORED_CLASS = exports.SERIALIZER_IGNORED_CLASS = 'en-serializer-ignore';

const MessageNames = exports.MessageNames = {
  FORWARD_FETCH_REQUEST: 'EN_forwardFetchRequest',
  REPORT_PROGRESS: 'EN_progress',
  INSTALL_SERIALIZER: 'EN_installFrameSerializer',
  INSTALL_AND_SERIALIZE_ALL: 'EN_installAndSerializeAll',
  INSTALL_AND_SERIALIZE_TO: 'EN_installAndSerializeTo',
  SERIALIZE: 'EN_serialize'
};

const ClipTypes = exports.ClipTypes = {
  ARTICLE: 'article',
  FULL_PAGE: 'fullPage',
  SIMPLIFIED: 'simplified',
  PDF: 'pdf',
  EMAIL: 'email',
  SELECTION: 'selection',
  BOOKMARK: 'bookmark',
  SCREENSHOT: 'screenshot',
  TOP_SITE: 'topsite'
};

/***/ }),

/***/ "./3rdParty/clipperCore/src/utilities/FrameChannel.js":
/*!************************************************************!*\
  !*** ./3rdParty/clipperCore/src/utilities/FrameChannel.js ***!
  \************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

//
//  FrameChannel.js
//  WebClipper
//
//  Created by zlosvik on 10/02/2017.
//  Copyright © 2017 Evernote Corporation. All rights reserved.
//

const ERROR_MARKER = '__error__';
const MESSAGE_REQUEST = 'EN_request';
const MESSAGE_RESPONSE = 'EN_response';

class FrameChannel {
  constructor(channelName, requestHandlers) {
    this._channelName = channelName || '';
    this._requestHandlers = requestHandlers;
    this._uniqueMessageID = 0;
    this._pendingMessages = {};
    this._handleMessage = this._handleMessage.bind(this);
  }

  start() {
    window.addEventListener('message', this._handleMessage);
  }

  stop() {
    window.removeEventListener('message', this._handleMessage);
  }

  sendMessageToFrame(frame, name, data) {
    return this.sendMessage(frame.contentWindow, name, data);
  }

  sendMessageToParent(name, data) {
    return this.sendMessage(window.parent, name, data);
  }

  sendMessage(targetWindow, name, data) {
    return new Promise((resolve, reject) => {
      const messageID = `${this._channelName}-${++this._uniqueMessageID}`;
      const message = { type: MESSAGE_REQUEST, messageID, name, data };
      this._pendingMessages[messageID] = { name, resolve, reject };
      targetWindow.postMessage(message, '*');
    });
  }

  _handleMessage(message) {
    if (!message.data) {
      return Promise.resolve();
    }
    const type = message.data.type;

    switch (type) {
      case MESSAGE_REQUEST:
        return this._handleRequest(message.data, message.source);
      case MESSAGE_RESPONSE:
        return this._handleResponse(message.data);
      default:
        return Promise.resolve();
    }
  }

  _handleRequest(message, sourceWindow) {
    const name = message.name,
          messageID = message.messageID;

    const handler = this._requestHandlers[name];
    if (!handler) {
      return;
    }
    const handlerResponse = handler(message.data || {});
    Promise.resolve(handlerResponse).catch(error => ({ [ERROR_MARKER]: _extends({}, error, { stack: error.stack, message: error.message }) })).then(data => {
      const response = { type: MESSAGE_RESPONSE, messageID, name, data };
      sourceWindow.postMessage(response, '*');
    });
  }

  _handleResponse(message) {
    const messageID = message.messageID;

    const pendingMessage = this._pendingMessages[messageID];
    if (!pendingMessage) {
      return;
    }
    const resolve = pendingMessage.resolve,
          reject = pendingMessage.reject;

    if (message.data && message.data[ERROR_MARKER]) {
      reject(message.data[ERROR_MARKER]);
    }
    resolve(message.data);
    delete this._pendingMessages[messageID];
  }
}
exports.default = FrameChannel;

/***/ }),

/***/ "./3rdParty/clipperCore/src/utilities/selectionUtils.js":
/*!**************************************************************!*\
  !*** ./3rdParty/clipperCore/src/utilities/selectionUtils.js ***!
  \**************************************************************/
/*! no static exports found */
/*! all exports used */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelection = getSelection;
exports.getRanges = getRanges;
exports.createRange = createRange;
exports.removeSelection = removeSelection;
exports.isRangeAfter = isRangeAfter;
exports.isNodeInRange = isNodeInRange;
function getSelection(targetWindow = window) {
  return targetWindow.getSelection();
}

function getRanges(selection) {
  const ranges = [];
  for (let i = 0; i < selection.rangeCount; i++) {
    if (!selection.getRangeAt(i).collapsed) {
      ranges.push(selection.getRangeAt(i));
    }
  }
  return ranges;
}

function createRange(rangeInfo) {
  if (!rangeInfo) return null;
  const rangeData = rangeInfo;
  const range = document.createRange();
  const startElm = document.querySelector(rangeData.startContainer).childNodes[rangeInfo.startTextNodePosition];
  const endElm = document.querySelector(rangeData.endContainer).childNodes[rangeInfo.endTextNodePosition];
  if (startElm && endElm) {
    range.setStart(startElm, rangeData.startOffset || 0);
    range.setEnd(endElm, rangeData.endOffset || 0);
    return range;
  }
  return null;
}

function removeSelection(targetWindow = window) {
  if (targetWindow.getSelection().empty) {
    // Chrome
    targetWindow.getSelection().empty();
  } else if (targetWindow.getSelection().removeAllRanges) {
    // Firefox
    targetWindow.getSelection().removeAllRanges();
  }
}

function isRangeAfter(range1, range2) {
  return range1.compareBoundaryPoints(Range.START_TO_START, range2) > 0 || range1.compareBoundaryPoints(Range.END_TO_END, range2) > 0 || range1.compareBoundaryPoints(Range.END_TO_START, range2) > 0 || range1.compareBoundaryPoints(Range.START_TO_END, range2) > 0;
}

function isNodeInRange(textNode, range, targetWindow = window) {
  const nodeRange = targetWindow.document.createRange();
  nodeRange.selectNode(textNode);
  if (textNode.nodeValue && range.isPointInRange(textNode, 0)) {
    return true;
  }
  if (textNode === range.startContainer || textNode === range.endContainer) {
    return true;
  }
  if (textNode === range.startContainer.childNodes[0] || textNode === range.startContainer.childNodes[0]) {
    return true;
  }
  return false;
}

/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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