(function (minWidth, minHeight) {
    function isValidCoverImage(image) {
		var width = image.naturalWidth;
		var height = image.naturalHeight;
		if(width < minWidth || height < minHeight) {
			return false;
		}
		return true;
	}

    function isSpecificHost(regex) {
        var host = window.location.host;
        return host.search(regex) !== -1;
    }

    function isDouyin() {
        var regex = /douyin.com/i;
        return isSpecificHost(regex);
    }

    function isXiaohongshu() {
        var regex = /xiaohongshu.com/i
        return isSpecificHost(regex)
    }

    function findArticleTitle() {
        try {
            if(typeof window.YXJSBridge !== 'undefined' && isXiaohongshu()) {
                var pattern = window.YXJSBridge.xiaohongshuTitlePattern();
                var titleDiv = document.querySelector(pattern);
                if(titleDiv != null) {
                    var title = titleDiv.textContent || titleDiv.innerText;
                    if(typeof title !== 'undefined') {
                        return title;
                    }
                } else {
                    var des = document.querySelector('meta[name="description"]');
                    var text = des.getAttribute('content');
                    if(text != null) {
                        return text;
                    }
                }
            }
        } catch (error) {
            console.log(error.toString());
        }
        

        var title = document.title;
        if(isDouyin()) {
            var plist = document.querySelectorAll('.footer > .desc');
            if(plist.length > 0) {
                title = plist[0].textContent;
            }
        }
        return title;
    }

    function getVideoSource(e) {
        // 获取视频src
        try {
            var sources = [];
            var videos = e.querySelectorAll("video");
            for (var i=0; i<videos.length; i++){
                var video = videos[i];
                var src = video.getAttribute("src")
                if (src != null) {
                    sources.push(src);
                }
            }
            return sources
        } catch (error) {
            console.log(error.toString());
            return null;
        }
    }

    var videoSources = getVideoSource(document.body);
    var imgs = document.querySelectorAll('img');
    var found = null;
    for (var i = 0; i < imgs.length; i++) {
        var img = imgs[i];
        if(isValidCoverImage(img)) {
            found = img;
            break;
        }
    }

    var coverSrc = null;
    if(found !== null) {
        coverSrc = found.getAttribute('src');
        if(coverSrc !== null && coverSrc !== "") {
            if(coverSrc.startsWith("//")) {
                coverSrc = "https:" + coverSrc;
            }
        }
    }

    var title = findArticleTitle();

    return {
        title: title,
        videoSources: videoSources,
        coverSrc: coverSrc
    }
})($1,$2)
