# NavigationStackViewBottomItem UI 修改文档

## 修改概述

根据UI设计需求，对侧边栏底部垃圾箱区域进行了以下修改：

1. **添加文案标签**：在垃圾箱图标旁边添加"回收站"文案
2. **调整布局**：将垃圾箱区域向左移动20像素间距
3. **优化交互**：整个垃圾箱容器区域都可以点击

## 具体修改内容

### 1. 新增UI组件

#### 垃圾箱标签 (trashLabel)
```swift
private lazy var trashLabel: NSTextField = {
  let label = NSTextField(labelWithString: NSLocalizedString("回收站", comment: "Trash label"))
  label.font = NSFont.systemFont(ofSize: 13)
  label.textColor = NSColor.labelColor
  label.alignment = .left
  return label
}()
```

#### 垃圾箱容器 (trashContainer)
```swift
private lazy var trashContainer: NSView = {
  let container = NSView()
  container.addSubview(trashButton)
  container.addSubview(trashLabel)
  
  // 添加点击手势识别器，使整个容器都可以点击
  let clickGesture = NSClickGestureRecognizer(target: self, action: #selector(trashContainerDidClick))
  container.addGestureRecognizer(clickGesture)
  
  // 布局约束
  trashButton.snp.makeConstraints { make in
    make.left.equalToSuperview()
    make.centerY.equalToSuperview()
  }
  
  trashLabel.snp.makeConstraints { make in
    make.left.equalTo(trashButton.snp.right).offset(8)
    make.centerY.equalToSuperview()
    make.right.equalToSuperview()
  }
  
  return container
}()
```

### 2. 布局修改

#### StackView更新
- 将原来的 `trashButton` 替换为 `trashContainer`
- 保持其他布局逻辑不变

#### 左间距调整
在 `relayoutSubviews()` 方法中添加了左间距约束：
```swift
if layoutMode == .full {
  stackView.snp.remakeConstraints { make in
    make.left.equalToSuperview().offset(20)  // 添加向左间距20
    make.right.equalToSuperview().inset(16)
    make.centerY.equalToSuperview()
  }
}
```

### 3. 交互优化

#### 容器点击处理
新增了容器点击方法，确保点击文案区域也能触发垃圾箱功能：
```swift
@objc private func trashContainerDidClick() {
  // 容器点击时委托给垃圾箱按钮处理
  trashButtonDidClick()
}
```

#### 外部访问接口更新
更新了 `getTrashButtonView()` 方法，返回整个容器而不是单独的按钮：
```swift
@objc func getTrashButtonView() -> NSView {
  return trashContainer
}
```

### 4. 主题适配

在 `reapplyTheme()` 方法中添加了标签颜色更新：
```swift
override func reapplyTheme() {
  super.reapplyTheme()
  
  // 更新标签颜色以适应主题变化
  trashLabel.textColor = NSColor.labelColor
  
  relayoutSubviews()
}
```

## 视觉效果

### 修改前
- 只有垃圾箱图标
- 居中对齐布局

### 修改后
- 垃圾箱图标 + "回收站"文案
- 向左偏移20像素
- 图标和文案之间8像素间距
- 整个区域可点击

## 兼容性说明

1. **布局模式兼容**：修改只影响 `.full` 模式的布局，`.iconOnly` 模式保持原有逻辑
2. **主题兼容**：支持深色/浅色主题自动切换
3. **交互兼容**：保持原有的点击、选中状态逻辑不变
4. **国际化兼容**：使用 `NSLocalizedString` 支持多语言

## 注意事项

1. 文案使用了硬编码的中文"回收站"，如需支持其他语言，需要在相应的本地化文件中添加翻译
2. 字体大小设置为13，与其他UI元素保持一致
3. 点击手势识别器确保了整个容器区域的交互性
4. 保持了原有的分析事件记录逻辑

## 测试建议

1. **布局测试**：验证在不同窗口大小下的布局表现
2. **主题测试**：测试深色/浅色主题切换时的显示效果
3. **交互测试**：确认点击图标和文案都能正确触发垃圾箱功能
4. **状态测试**：验证选中状态的视觉反馈是否正确