/* eslint-disable max-len */
/* eslint-disable no-var */
/* eslint-disable no-new-object */
(function() {
    var EVELog = {
        _logWithPrefix: function _logWithPrefix(prefix, args) {
            var _args = Array.prototype.slice.call(args);
            var msg = (prefix) ? '[' + prefix + '] ' + _args : _args;
            console.log(msg);
            if (typeof webkit !== 'undefined') {
                webkit.messageHandlers.yxloghandler.postMessage({'log': msg});
            }
        },
        debug: function debug() {
            this._logWithPrefix('DEBUG', arguments);
        },
        info: function info() {
            this._logWithPrefix('INFO', arguments);
        },
        warn: function warn() {
            this._logWithPrefix('WARN', arguments);
        },
        error: function error() {
            this._logWithPrefix('ERROR', arguments);
        },
        _Durations: {},
        debugDuration: function debugDuration(fn, msg) {
            var start = Date.now();
            fn();
            var end = Date.now();
            var fnName = fn.name || '(anonymous function)';
            console.log('Duration of ' + fnName + ': ' + (end - start) + 'ms');
        },
        debugStartDuration: function debugStartDuration(key) {
            EVELog._Durations[key] = Date.now();
        },
        debugEndDuration: function debugEndDuration(key) {
            var duration = Date.now() - EVELog._Durations[key];
            delete EVELog._Durations[key];
            console.log('Duration of ' + key + ': ' + duration + 'ms');
        },
        prettyFunction: function prettyFunction(context, logArgs, includeCaller) {
            var caller = arguments.callee.caller;
            var constructor = (typeof context == 'string') ? context : context.constructor.name;
            var callerName = caller.name || '__anonymous__';
            var parts = ((constructor) ? [constructor] : []).concat(callerName);
            var out = parts.join('.');
            if (logArgs && typeof context != 'string') {
                var args = caller['arguments'];
                if (args) {
                    var argStrings = Array.prototype.slice.call(args);
                    for (var i = 0; i < argStrings.length; i++) {
                        var arg = argStrings[i];
                        if (typeof arg == 'string') {
                            argStrings[i] = '"' + arg + '"';
                        }
                        else if (arg instanceof Node) {
                            var txt = arg.textContent.trim();
                            if (txt.length > 10) {
                                txt = txt.substring(0, 7) + '...';
                            }
                            argStrings[i] = arg.nodeName + '[' + txt + ']';
                        }
                        else if (arg instanceof HTMLElement) {
                            argStrings[i] = '<' + arg.nodeName + '>';
                        }
                    }
                    out += '(' + argStrings.join(', ') + ')';
                }
            }
            if (includeCaller) {
                var parentCaller = caller.caller;
                out += ' <- ' + ((parentCaller) ? parentCaller.name : '__anonymous__');
            }
            console.log(out);
        }
    };

    var YXUtility = function () {
    };
    YXUtility.prototype.isSpecificHost = function isSpecificHost(regex) {
        var host = window.location.host;
        return host.search(regex) !== -1;
    };
    YXUtility.prototype.isShitang = function isShitang() {
        var regex = /yinxiang.com\/everhub\/note/i;
        return window.location.href.search(regex) !== -1;
    };
    YXUtility.prototype.isWeChatArticle = function isWeChatArticle() {
        var regex = /mp.weixin.qq.com/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isRenmin = function isRenmin() {
        var regex = /wap.peopleapp.com/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isWeibo = function isWeibo() {
        var regex = /m.weibo/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isTouTiao = function isTouTiao() {
        var regex = /m.toutiao.com/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isZhihu = function isZhihu() {
        var regex = /zhihu.com/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isBaiduNews = function isBaiduNews() {
        var regex = /mbd.baidu.com/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isXuexiQiangGuo = function isXuexiQiangGuo() {
        var regex = /article.xuexi.cn/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isDouyin = function isDouyin() {
        var regex = /douyin.com/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isXiaohongshu = function isXiaohongshu() {
        var regex = /xiaohongshu.com/i;
        return this.isSpecificHost(regex);
    };
    YXUtility.prototype.isBilibili = function isBilibili() {
        var regex = /m.bilibili.com/i;
        return this.isSpecificHost(regex);
    };
    /**
     * 是否该image可以做瀑布流的卡片Cover
     * @param {image} image the image.
     * @return {boolean} true or false.
     */
    YXUtility.prototype.isValidCoverImage = function isValidCoverImage(image) {
        var width = image.naturalWidth;
        var height = image.naturalHeight;

        var filterCoverWidth = 252;
        var filterCoverHeight = 189;

        try {
            filterCoverWidth = window.favorit_extension.filterCoverWidth;
            filterCoverHeight = window.favorit_extension.filterCoverHeight;
        } catch (error) {
            dbg(error.toString());
        }

        EVELog.debug('isValidCoverImage Width: ' + width + ', height:' + height);

        if (width < filterCoverWidth || height < filterCoverHeight) {
            return false;
        }
        return true;
    };
    YXUtility.prototype.getSiteName = function getSiteName() {
        var type = 'other';
        if (readability.isDouyin()) {
            type = 'douyin';
        } else if (readability.isXiaohongshu()) {
            type = 'xiaohongshu';
        } else if (readability.isBilibili()) {
            type = 'bilibili';
        }
        return type;
    };
    YXUtility.prototype.getArticleTitle = function getArticleTitle(doc) {
        var curTitle = '';
        var origTitle = '';

        try {
            if (doc === null || typeof doc == 'undefined') {
                doc = document;
            }
            curTitle = origTitle = doc.title;

            if (typeof curTitle !== 'string') {
                curTitle = origTitle = readability.getInnerText(doc.getElementsByTagName('title')[0]);
            }

            var titleNode = doc.querySelectorAll('.title')[0];
            if (typeof titleNode !== 'undefined') {
                EVELog.debug('title node is not null');
                var text = titleNode.innerText;
                if (text !== null) {
                    EVELog.debug('title node\'s text is ' + text);
                    curTitle = text;
                }
            }
        }
        catch (e) {
            EVELog.debug(e.toString());
        }

        return curTitle;
    };
    YXUtility.prototype.findWebPageBasicInfo = function findWebPageBasicInfo(skipSiteRegex) {
        var basicInfo = {
            title: '',
            desc: '',
            cover: '',
        };

        var isSkip = typeof skipSiteRegex !== 'undefined' && this.isSpecificHost(skipSiteRegex);
        if (!isSkip) {
            var metas = document.getElementsByTagName('meta');
            var count = 0;
            for (var i = 0; i < metas.length; i++) {
                var meta = metas[i];
                var property = meta.getAttribute('property');
                if (property) {
                    if (property === 'og:title' || property == 'twitter:title') {
                        basicInfo.title = meta.getAttribute('content');
                        count++;
                        continue;
                    } else if (property === 'og:description' || property == 'twitter:description') {
                        basicInfo.desc = meta.getAttribute('content');
                        count++;
                        continue;
                    } else if (property === 'og:image' || property == 'twitter:image') {
                        basicInfo.cover = meta.getAttribute('content');
                        count++;
                    }
                }

                if (count === 3) {
                    break;
                }
            }
        }

        if (basicInfo.title === '') {
            basicInfo.title = this.getArticleTitle();
        }
        return basicInfo;
    };
    YXUtility.prototype.onDocReady = function onDocReady(callback) {
        // see if DOM is already available
        if (document.readyState === 'complete' || document.readyState === 'interactive') {
            // call on next available tick
            setTimeout(callback, 1);
        } else {
            document.addEventListener('DOMContentLoaded', callback);
        }
    };
    YXUtility.prototype.onCSSReady = function onCSSReady(callback) {
        var cssnum = document.styleSheets.length;
        window.yxLogger.debug('onCSSReady start, stylesheets:'+document.styleSheets.length);
        var ti = setInterval(function() {
            if (document.styleSheets.length !== cssnum) {
                cssnum = document.styleSheets.length;
                return;
            }
            window.yxLogger.debug('onCSSReady end:'+document.styleSheets.length);
            clearInterval(ti);
            // call on next available tick
            setTimeout(callback, 1);
        }, 50);
    };
    window.yxUtility = new YXUtility();
    window.yxLogger = new Object(EVELog);

    window.yxUtility.onDocReady(function() {
        window.yxLogger.debug('---------------------------onDocReady-----------------------');
        window.yxUtility.onCSSReady(function() {
            window.yxLogger.debug('---------------------------css ready----------------------- css files: ' + document.styleSheets.length);
            window.YXJSBridge.notifyDocReady();
        });
    });
})();
