# Coding Guidelines – Notebook Module (Swift)

- No single-line function bodies
  - Do not write `func foo() { bar() }`.
  - Always expand to multi-line:
    - `func foo() {\n  bar()\n}`
- No implicitly unwrapped optionals / forced unwraps / forced casts
  - Avoid `!` and `as!` in module code.
  - Prefer optional binding / guard / safe casts.
- Follow Tags module UI patterns
  - Header search uses a container view with SnapKit constraints; `NSTextFieldDelegate` for real-time search.
  - Use the same margins, colors, and stack structures as TagList components.
- SnapKit only for constraints
  - Do not mix with NSLayoutConstraint literals.
- Notebook note count
  - Prefer `activeNoteCountValue` via KVC; fallback to `activeNoteCount` number.
- Observer lifecycle
  - Attach in init; detach in deinit; rebuild on main thread.

These rules are applied to all files under `.../Notebook Module Swift/`.
