# Whiteboard远程代理本地测试指南

## 🚀 快速开始

### 1. 部署测试服务器

在Evernote工程根目录下执行：

```bash
# 运行部署脚本
bash setup-test-server.sh
```

这会在工程目录下创建 `whiteboard-test-server/` 目录，包含所有测试文件。

### 2. 启动测试服务器

```bash
# 进入测试目录并启动服务器
cd whiteboard-test-server
./start-server.sh
```

或者手动启动：

```bash
cd whiteboard-test-server
python3 -m http.server 8888
```

### 3. 验证服务器运行

在浏览器中访问：`http://localhost:8888`

你应该能看到测试页面正常加载。

### 4. 在Evernote中测试

```objc
// 配置localhost测试服务器
ENWhiteboardEditorWKWebView *webView = self.whiteboardWebView;
[webView loadRemoteWhiteboardFromURL:@"http://localhost:8888"];

// 运行全面测试
[webView runComprehensiveRemoteTest];
```

## 📋 测试内容

部署的测试服务器包含：

- **index.html** - 主测试页面，包含环境检测和功能测试
- **client.html** - 模拟Whiteboard客户端页面
- **test.css** - 响应式样式文件
- **superTable.js** - 功能测试脚本
- **start-server.sh** - 一键启动脚本

## 🧪 测试功能

1. **URL重写检测** - 验证evernotecid://协议是否被正确重写
2. **静态资源加载** - 测试CSS/JS文件是否通过代理正确加载
3. **API代理功能** - 测试evernotecid://协议的本地代理
4. **环境信息** - 显示当前运行环境和配置
5. **性能测试** - 批量请求和响应时间测试

## 📊 验证步骤

### 浏览器验证
1. 访问 `http://localhost:8888`
2. 点击"运行所有测试"按钮
3. 查看测试结果和控制台日志

### Evernote应用验证
1. 配置远程服务器URL
2. 执行 `runComprehensiveRemoteTest`
3. 查看Xcode控制台日志

### 预期结果
- ✅ 页面正常加载和显示
- ✅ CSS样式正确应用
- ✅ JavaScript文件成功加载
- ✅ URL重写脚本正确注入
- ✅ evernotecid://协议请求正常转换

## 🔧 常见问题

### 端口被占用
如果8888端口被占用，启动脚本会自动尝试8889端口。

### Python版本问题
- 推荐使用Python 3: `python3 -m http.server 8888`
- Python 2也支持: `python -m SimpleHTTPServer 8888`

### 权限问题
如果脚本无法执行：
```bash
chmod +x setup-test-server.sh
chmod +x whiteboard-test-server/start-server.sh
```

## 📝 工程配置

### 添加到.gitignore
建议将测试目录添加到.gitignore：
```bash
echo 'whiteboard-test-server/' >> .gitignore
```

### 清理测试文件
如需清理测试文件：
```bash
rm -rf whiteboard-test-server/
```

## 🎯 测试场景

### 基本功能测试
```objc
[webView loadRemoteWhiteboardFromURL:@"http://localhost:8888"];
```

### 切换模式测试
```objc
// 远程模式
[webView configureRemoteServer:[NSURL URLWithString:@"http://localhost:8888"]];

// 本地模式  
[webView configureRemoteServer:nil];
```

### 性能测试
```objc
[webView runComprehensiveRemoteTest];
```

## 📊 日志监控

### 服务器日志
启动服务器后会显示所有请求：
```
127.0.0.1 - - [时间] "GET /index.html HTTP/1.1" 200 -
127.0.0.1 - - [时间] "GET /test.css HTTP/1.1" 200 -
127.0.0.1 - - [时间] "GET /superTable.js HTTP/1.1" 200 -
```

### 应用日志
在Xcode控制台查看详细日志：
```
[WhiteboardHTTP] 🌐 Remote server configured: http://localhost:8888
[WhiteboardHTTP] 🌐 Proxying remote request: /index.html -> http://localhost:8888/index.html
[WhiteboardJS] HTTP environment detected, enabling URL rewriting
```

这样你就可以在工程目录下方便地测试Whiteboard的远程代理功能了！