# Whiteboard实际资源URL测试指南

## 🎯 测试目标

使用真实的evernotecid URL `evernotecid://84D5E09F-B16A-446E-9E00-DB3B80E615C1/stage4yinxiangcom/10241/ENResource/p16` 验证整个HTTP代理和URL重写流程是否正常工作。

## 🚀 测试流程

### 1. 启动localhost测试服务器

```bash
cd /Users/wright/YXCode/mac/whiteboard-test-server
./start-server.sh
```

应该看到：
```
🚀 启动Whiteboard测试服务器...
📂 当前目录: /Users/wright/YXCode/mac/whiteboard-test-server
🌐 访问地址: http://localhost:8888
🛑 按 Ctrl+C 停止服务器
🐍 使用Python 3启动服务器...
```

### 2. 验证测试页面可访问

在浏览器中访问 `http://localhost:8888` 应该看到：
- 页面标题：`🌐 Whiteboard远程测试服务器`
- CSS样式正确加载（渐变背景）
- JavaScript正确加载（控制台显示加载信息）

### 3. 在应用中配置远程代理

在ENWhiteboardEditorWKWebView中设置debugLocalEditorURL：

```objc
// 方法1: 通过代码设置
self.debugLocalEditorURL = [NSURL URLWithString:@"http://localhost:8888"];

// 方法2: 通过调用现有测试方法
[self testLocalhostRemoteProxy];
```

### 4. 验证代理配置成功

应该在Xcode控制台看到：
```
[WhiteboardWebView] 🌐 Detected remote HTTP URL, enabling remote proxy
[WhiteboardWebView] 🔧 Initializing HTTP server...
[WhiteboardWebView] 🚀 Starting HTTP server...
[WhiteboardWebView] ✅ HTTP server started at: http://127.0.0.1:9999
[WhiteboardWebView] 🎯 Configuring remote server: http://localhost:8888
[WhiteboardHTTP] 🌐 Remote server configured: http://localhost:8888
[WhiteboardWebView] 🔄 Returning proxy URL: http://127.0.0.1:9999/index.html
```

### 5. 在WebView中测试evernotecid URL

WebView加载后，在测试页面中：

1. **点击"测试evernotecid://协议"按钮**
2. **或者点击"运行所有测试"按钮**

### 6. 观察测试结果

#### 6.1 浏览器控制台输出
```javascript
[WhiteboardJS] HTTP environment detected, enabling URL rewriting
[WhiteboardJS] Converted fetch URL: evernotecid://84D5E09F-B16A-446E-9E00-DB3B80E615C1/stage4yinxiangcom/10241/ENResource/p16 -> /api/evernotecid/84D5E09F-B16A-446E-9E00-DB3B80E615C1/stage4yinxiangcom/10241/ENResource/p16
```

#### 6.2 Xcode控制台输出
```
[WhiteboardHTTP] 📥 API proxy request: /api/evernotecid/84D5E09F-B16A-446E-9E00-DB3B80E615C1/stage4yinxiangcom/10241/ENResource/p16
[WhiteboardHTTP] 🔗 Handling evernotecid protocol: 84D5E09F-B16A-446E-9E00-DB3B80E615C1/stage4yinxiangcom/10241/ENResource/p16
[WhiteboardHTTP] ✅ evernotecid protocol response: 200, 52341 bytes, image/png
```

#### 6.3 测试页面显示
```
[时间戳] 开始测试真实evernotecid://协议...
[时间戳] 📍 测试URL: evernotecid://84D5E09F-B16A-446E-9E00-DB3B80E615C1/stage4yinxiangcom/10241/ENResource/p16
[时间戳] 📊 响应时间: 45ms
[时间戳] 📊 响应状态: 200 OK
[时间戳] 📊 Content-Type: image/png
[时间戳] ✅ evernotecid请求成功: 200
[时间戳] 📦 数据大小: 52341 字节
[时间戳] 🎯 数据类型: PNG图片
[时间戳] 🖼️ 图片显示成功 (256x256)
```

## 🔍 测试验证要点

### ✅ 成功标志

1. **URL重写正常**：evernotecid:// 被转换为 /api/evernotecid/
2. **HTTP代理工作**：本地服务器正确处理API请求
3. **协议转换成功**：evernotecid协议正确转换为内部资源获取
4. **数据返回正确**：获取到预期的资源数据
5. **类型识别正确**：正确识别为PNG图片格式
6. **图片显示成功**：如果是图片，能正确在页面中显示

### ❌ 失败情况诊断

#### 1. URL重写失败
- **现象**：直接请求evernotecid://报CORS错误
- **原因**：JavaScript重写逻辑未生效
- **检查**：确认在HTTP环境下访问，查看控制台是否有重写日志

#### 2. 代理服务器无响应
- **现象**：404 Not Found
- **原因**：本地HTTP服务器未启动或路由配置错误
- **检查**：确认本地服务器正在运行，检查端口号

#### 3. evernotecid协议处理失败
- **现象**：500 Internal Server Error
- **原因**：ENContentProtocol调用失败或资源不存在
- **检查**：验证账户状态和资源ID是否有效

#### 4. 资源获取失败
- **现象**：获取到数据但大小为0或格式错误
- **原因**：资源已过期或权限不足
- **检查**：尝试其他已知有效的资源ID

## 📊 性能基准

### 正常响应时间
- **本地协议处理**：< 50ms
- **网络请求重写**：< 10ms
- **总体响应时间**：< 100ms

### 典型资源大小
- **小图标**：1-5KB
- **普通图片**：10-100KB
- **大图片**：100KB-1MB

## 🛠 调试技巧

### 1. 启用详细日志
在ENWhiteboardHTTPServer.m中启用所有AppLogInfo语句

### 2. 网络监控
使用Safari/Chrome开发者工具监控网络请求

### 3. 断点调试
在以下关键方法设置断点：
- `handleEvernoteCidAPIRequest:`
- `handleRemoteProxyRequest:forPath:`
- JavaScript fetch重写逻辑

### 4. 测试不同资源
尝试不同的evernotecid URL以验证通用性

## 🎉 测试完成标准

当以下所有项目都通过时，表示测试成功：

- [ ] localhost服务器正常启动
- [ ] WebView成功加载远程HTML
- [ ] JavaScript重写逻辑正常工作
- [ ] evernotecid://协议正确转换
- [ ] 资源数据成功获取
- [ ] 数据类型正确识别
- [ ] 如果是图片，正确显示在页面中
- [ ] 响应时间在预期范围内
- [ ] 无JavaScript错误或异常

## 📝 测试记录模板

```
测试时间：____年__月__日 __:__
测试环境：macOS ___
应用版本：____
测试资源：evernotecid://84D5E09F-B16A-446E-9E00-DB3B80E615C1/stage4yinxiangcom/10241/ENResource/p16

[ ] 服务器启动成功
[ ] 页面加载成功
[ ] URL重写生效
[ ] 协议转换成功
[ ] 资源获取成功
[ ] 数据类型正确
[ ] 显示效果正常
[ ] 性能表现良好

备注：
________________
________________
```