# Whiteboard远程代理测试集成方案

## 🎯 测试代码集成位置

### 方法1: 直接调用现有方法 (推荐)

```objc
// 在任何地方调用现有的测试方法
ENWhiteboardEditorWKWebView *webView = self.whiteboardWebView; // 获取你的webView实例
[webView testLocalhostRemoteProxy];
```

### 方法2: 添加到viewDidLoad或其他初始化方法

```objc
// 例如在某个ViewController的viewDidLoad中
- (void)viewDidLoad {
    [super viewDidLoad];
    
    // 延迟执行测试 (等待UI完全加载)
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(2.0 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        if (self.whiteboardWebView) {
            [self.whiteboardWebView testLocalhostRemoteProxy];
        }
    });
}
```

### 方法3: 添加调试菜单项

如果你想通过菜单触发测试，可以添加到主菜单：

```objc
// 在AppDelegate或相关类中添加
- (void)setupDebugMenu {
    NSMenu *mainMenu = [NSApp mainMenu];
    NSMenu *debugMenu = [[NSMenu alloc] initWithTitle:@"Debug"];
    
    NSMenuItem *testItem = [[NSMenuItem alloc] initWithTitle:@"Test Localhost Remote Proxy" 
                                                      action:@selector(testLocalhostRemoteProxy:) 
                                               keyEquivalent:@"t"];
    testItem.keyEquivalentModifierMask = NSEventModifierFlagCommand | NSEventModifierFlagShift;
    testItem.target = self;
    
    [debugMenu addItem:testItem];
    
    NSMenuItem *debugMenuItem = [[NSMenuItem alloc] initWithTitle:@"Debug" action:nil keyEquivalent:@""];
    debugMenuItem.submenu = debugMenu;
    [mainMenu addItem:debugMenuItem];
}

- (void)testLocalhostRemoteProxy:(id)sender {
    // 获取当前活动的WebView
    ENWhiteboardEditorWKWebView *webView = [self getCurrentWhiteboardWebView];
    if (webView) {
        [webView testLocalhostRemoteProxy];
    }
}
```

### 方法4: 添加键盘快捷键

```objc
// 在NSViewController或NSView的子类中
- (void)keyDown:(NSEvent *)event {
    // Command+Shift+T 触发测试
    if (event.modifierFlags & NSEventModifierFlagCommand && 
        event.modifierFlags & NSEventModifierFlagShift &&
        [event.charactersIgnoringModifiers isEqualToString:@"t"]) {
        
        if (self.whiteboardWebView) {
            [self.whiteboardWebView testLocalhostRemoteProxy];
        }
        return;
    }
    
    [super keyDown:event];
}
```

### 方法5: 添加到按钮点击事件

```objc
// 如果你有UI按钮
- (IBAction)testButtonClicked:(id)sender {
    if (self.whiteboardWebView) {
        [self.whiteboardWebView testLocalhostRemoteProxy];
    }
}
```

### 方法6: 在Xcode调试时手动触发

在Xcode调试时，你可以在断点处手动执行：

```lldb
# 在LLDB控制台中执行
(lldb) po [(ENWhiteboardEditorWKWebView*)[[self whiteboardWebView]] testLocalhostRemoteProxy]

# 或者获取任意WebView实例
(lldb) po ENWhiteboardEditorWKWebView *webView = (ENWhiteboardEditorWKWebView*)[[[[NSApplication sharedApplication] mainWindow] contentViewController] whiteboardWebView]
(lldb) po [webView testLocalhostRemoteProxy]
```

## 🚀 推荐的测试流程

### 1. 启动测试服务器
```bash
cd /Users/wright/YXCode/mac/whiteboard-test-server
./start-server.sh
```

### 2. 验证服务器运行
浏览器访问: `http://localhost:8888`

### 3. 在应用中触发测试
选择上述任一方法调用测试代码

### 4. 查看测试结果
观察Xcode控制台输出和浏览器网络请求

## 📊 测试验证要点

### 应该看到的日志
```
[WhiteboardWebView] 🏠 开始localhost远程代理测试
[WhiteboardWebView] 🌐 配置远程服务器: http://localhost:8888
[WhiteboardHTTP] 🌐 Remote server configured: http://localhost:8888
[WhiteboardHTTP] 🌐 Proxying remote request: /index.html -> http://localhost:8888/index.html
[WhiteboardJS] HTTP environment detected, enabling URL rewriting
[WhiteboardJS] Converted fetch URL: evernotecid://... -> /api/evernotecid/...
```

### 服务器日志
```bash
127.0.0.1 - - [时间] "GET /index.html HTTP/1.1" 200 -
127.0.0.1 - - [时间] "GET /test.css HTTP/1.1" 200 -
127.0.0.1 - - [时间] "GET /superTable.js HTTP/1.1" 200 -
127.0.0.1 - - [时间] "GET /api/evernotecid/test-resource-id/sample/path HTTP/1.1" 200 -
```

## 💡 最简单的测试方法

如果你只是想快速测试，最简单的方法是：

1. **启动服务器**:
   ```bash
   cd /Users/wright/YXCode/mac
   bash setup-test-server.sh
   cd whiteboard-test-server
   ./start-server.sh
   ```

2. **在Xcode中设置断点**，然后在LLDB中执行:
   ```lldb
   # 假设你有webView实例
   po [webView testLocalhostRemoteProxy]
   ```

3. **或者添加到某个现有的按钮点击事件中**暂时测试。

这样你就可以方便地测试localhost远程代理功能了！