// Copyright (c) 2014 Evernote. All rights reserved.

// This file is run in external web pages. It should not use require.js.

(function () {

  var REFERENCE_SCREEN_RESOLUTION = 1440;
  var ADDITIONAL_ZOOM_PERCENT = 10;

  function ENCPPresenter() {
    this.userZoomLevel = 1;
  }

  /**
   * Update zoom level. Called from native code.
   * @param {Number} userZoomLevel
   */
  ENCPPresenter.prototype.updateUserZoomLevel = function (userZoomLevel) {
    this.userZoomLevel = userZoomLevel;
    this.scalePresentation();
  };

  ENCPPresenter.prototype.scalePresentation = function () {
    if (document && document.documentElement) {
      var zoomPercent = (window.innerWidth * 100 / REFERENCE_SCREEN_RESOLUTION) + ADDITIONAL_ZOOM_PERCENT;
      zoomPercent *= this.userZoomLevel;
      document.documentElement.style.zoom = '' + (zoomPercent / 100);
    }
  };

  ENCPPresenter.prototype.getTextSelection = function() {
    var selection = window.getSelection ? window.getSelection() : undefined;

    if (selection !== undefined && selection.rangeCount > 0) {
      return selection.getRangeAt(0).cloneContents().textContent;
    }

    return undefined;
  };

  if (!window.encpPresenter) {
    window.encpPresenter = new ENCPPresenter();
    window.encpPresenter.scalePresentation();

    window.addEventListener("DOMContentLoaded", function() {
      window.encpPresenter.scalePresentation();
    }, false);

    window.addEventListener('resize', function () {
      window.encpPresenter.scalePresentation();
    }, false);
  }
  
})();
