# Evernote Mac Tag Drag & Drop 功能测试检查清单

## 🧪 测试分类

### ✅ 基础功能测试
### ✅ 边界情况测试  
### ✅ 用户体验测试
### ✅ 性能测试
### ✅ 兼容性测试
### ✅ 安全测试

---

## 📋 基础功能测试

### 拖拽操作基础
- [ ] **BF-001** 能够开始拖拽标签
  - 鼠标按下标签项目后开始拖拽
  - 拖拽时显示标签内容
  - 拖拽指针正确显示
  
- [ ] **BF-002** 能够拖拽到其他标签上
  - 拖拽标签A到标签B上
  - 拖拽时标签B显示高亮
  - 释放后A成为B的子标签

- [ ] **BF-003** 能够拖拽到根级
  - 拖拽子标签到空白区域
  - 拖拽到OutlineView的空白处
  - 释放后标签成为顶级标签

### 层级关系验证
- [ ] **BF-004** 单层级嵌套正确
  - 顶级标签A拖到顶级标签B
  - 验证A成为B的子标签
  - 验证A的原始子标签跟随移动

- [ ] **BF-005** 多层级嵌套正确  
  - 标签A拖到B的子标签C
  - 验证A成为C的子标签
  - 验证层级关系 B -> C -> A

- [ ] **BF-006** 层级解除正确
  - 子标签拖到根级
  - 验证父子关系断开
  - 验证原父标签不受影响

### 数据持久化
- [ ] **BF-007** 拖拽后数据正确保存
  - 执行拖拽操作
  - 重启应用
  - 验证层级关系保持

- [ ] **BF-008** 同步机制正常工作
  - 执行拖拽操作  
  - 检查dirty标记设置
  - 验证数据自动同步

---

## 🔒 边界情况测试

### 循环引用防护
- [ ] **BC-001** 阻止简单循环引用
  - 标签A有子标签B
  - 尝试拖拽A到B
  - 验证操作被拒绝
  
- [ ] **BC-002** 阻止复杂循环引用
  - 层级关系: A -> B -> C -> D
  - 尝试拖拽A到D  
  - 验证操作被拒绝

- [ ] **BC-003** 阻止自己拖到自己
  - 尝试拖拽标签A到A自己
  - 验证操作被拒绝
  - 显示禁止图标

### 无效操作处理
- [ ] **BC-004** 拒绝拖到节点间
  - 尝试拖拽到两个标签之间
  - 验证 proposedChildIndex >= 0 时拒绝
  - 显示禁止图标

- [ ] **BC-005** 空数据处理
  - 拖拽数据损坏时的处理
  - pasteboard数据无效时的处理
  - 网络异常时的处理

### 大数据量测试  
- [ ] **BC-006** 大量标签性能
  - 测试1000+标签的拖拽
  - 验证响应速度
  - 检查内存使用

- [ ] **BC-007** 深层嵌套测试
  - 创建10层以上嵌套
  - 执行各种拖拽操作
  - 验证功能正常

---

## 🎨 用户体验测试

### 视觉反馈
- [ ] **UX-001** 拖拽开始反馈
  - 鼠标按下时的视觉变化
  - 拖拽图像的正确显示
  - 原位置的视觉状态

- [ ] **UX-002** 拖拽过程反馈
  - 悬停在有效目标时的高亮
  - 悬停在无效目标时的禁止图标
  - 拖拽轨迹的流畅性

- [ ] **UX-003** 拖拽结束反馈
  - 成功操作的确认效果
  - 失败操作的提示
  - UI状态的正确恢复

### 交互体验
- [ ] **UX-004** 拖拽流畅性
  - 60fps的拖拽动画
  - 无明显卡顿现象
  - 跟手性良好

- [ ] **UX-005** 错误提示清晰
  - 循环引用的错误提示
  - 无权限操作的提示
  - 网络异常的提示

- [ ] **UX-006** 状态保持
  - 拖拽后展开状态保持
  - 选中状态正确处理
  - 滚动位置保持

---

## ⚡ 性能测试

### 响应时间
- [ ] **PF-001** 拖拽启动时间
  - 鼠标按下到拖拽开始 < 50ms
  - 拖拽图像显示 < 100ms
  - 初始反馈延迟 < 16ms

- [ ] **PF-002** 验证逻辑时间  
  - validateDrop 执行时间 < 10ms
  - 循环引用检查时间 < 5ms
  - 大量标签时验证时间 < 50ms

- [ ] **PF-003** UI更新时间
  - 拖拽完成后UI刷新 < 200ms
  - 排序逻辑执行时间 < 100ms
  - 展开状态恢复 < 100ms

### 资源使用
- [ ] **PF-004** 内存使用
  - 拖拽操作内存增长 < 5MB
  - 无明显内存泄漏
  - 大量操作后内存回收正常

- [ ] **PF-005** CPU使用
  - 拖拽过程CPU使用率 < 30%
  - 动画播放CPU使用率 < 20%  
  - 后台处理不阻塞UI

---

## 🔗 兼容性测试

### 与现有功能兼容
- [ ] **CP-001** 标签创建功能
  - 拖拽功能不影响标签创建
  - 新创建标签可正常拖拽
  - 创建后排序逻辑正确

- [ ] **CP-002** 标签重命名功能
  - 拖拽功能不影响重命名
  - 重命名后拖拽功能正常
  - 重命名后排序位置正确

- [ ] **CP-003** 标签删除功能
  - 拖拽功能不影响删除
  - 删除父标签后子标签处理正确
  - 删除后UI状态正确

### 排序逻辑兼容
- [ ] **CP-004** 按名称排序
  - 拖拽后按名称排序正确
  - 新层级下排序位置正确
  - 搜索过滤时排序正确

- [ ] **CP-005** 按笔记数排序  
  - 拖拽后按笔记数排序正确
  - 笔记数变化时排序正确
  - 零笔记数标签处理正确

### 搜索功能兼容
- [ ] **CP-006** 搜索状态下拖拽
  - 搜索结果中的标签可拖拽
  - 拖拽到非搜索结果的标签
  - 拖拽后搜索结果更新

- [ ] **CP-007** 筛选状态下拖拽
  - "我的标签"筛选下的拖拽
  - "所有标签"筛选下的拖拽
  - 筛选切换后状态正确

---

## 🛡️ 安全测试

### 数据安全
- [ ] **SC-001** 数据完整性
  - 拖拽操作不丢失标签数据
  - 异常中断时数据不损坏
  - 关联笔记数据不受影响

- [ ] **SC-002** 权限验证
  - 只能操作当前账户标签
  - 不能拖拽到无权限的标签
  - 企业标签权限正确处理

### 操作安全
- [ ] **SC-003** 输入验证
  - 恶意拖拽数据处理
  - 异常标签GUID处理  
  - 非法操作序列处理

- [ ] **SC-004** 并发安全
  - 多个拖拽操作的并发处理
  - 数据同步时的并发安全
  - UI更新的线程安全

---

## 📱 设备兼容性测试

### 不同分辨率
- [ ] **DC-001** 标准分辨率 (1920x1080)
  - 拖拽功能正常工作
  - 视觉效果正确显示
  - 性能表现良好

- [ ] **DC-002** 高分辨率 (Retina)
  - 拖拽图像清晰度
  - 高亮效果显示正确
  - 动画流畅度保持

- [ ] **DC-003** 低分辨率 (1366x768)
  - 功能完整性保持
  - UI元素不重叠
  - 可用性不降低

### 不同系统版本
- [ ] **DC-004** macOS 10.14
  - 基础功能正常
  - API兼容性确认
  - 性能可接受

- [ ] **DC-005** macOS 11.0+
  - 新特性利用
  - 系统集成良好
  - 原生体验

---

## 🎯 验收标准

### 功能完整性
- [ ] **AC-001** 所有基础功能测试通过率 > 95%
- [ ] **AC-002** 所有边界情况测试通过率 > 90%
- [ ] **AC-003** 所有用户体验测试通过率 > 95%

### 性能指标
- [ ] **AC-004** 拖拽响应时间 < 100ms
- [ ] **AC-005** UI更新时间 < 200ms  
- [ ] **AC-006** 内存使用增长 < 5%

### 质量指标
- [ ] **AC-007** 无严重Bug (Severity 1-2)
- [ ] **AC-008** 轻微Bug < 5个 (Severity 3-4)
- [ ] **AC-009** 代码覆盖率 > 80%

---

## 📋 测试执行记录

### 测试环境
- **操作系统**: macOS ___
- **测试设备**: ___
- **应用版本**: ___
- **测试日期**: ___
- **测试人员**: ___

### 缺陷记录模板
```
缺陷ID: TD-XXX
测试用例: [测试用例ID]
严重级别: [1-Critical / 2-Major / 3-Minor / 4-Trivial]
复现步骤:
1. 
2. 
3.
期望结果:
实际结果:
附件:
状态: [New/InProgress/Fixed/Verified/Closed]
```

### 回归测试
- [ ] **修复验证**: 每个修复的Bug需要回归验证
- [ ] **影响范围测试**: 确认修复不影响其他功能
- [ ] **性能回归**: 确认修复不影响性能指标

---

**检查清单版本**: v1.0  
**创建日期**: 2025-11-21  
**最后更新**: 2025-11-21  
**预计测试时间**: 3-4天  
**建议测试人员**: 2-3人  