# Evernote Mac Tag Drag & Drop 项目文档

## 📁 文档结构

这个文件夹包含了 Evernote Mac 应用标签拖拽功能的完整设计和开发文档。

### 📄 文档列表

#### 01. 设计规范
**文件**: `01_Tag_DragDrop_Design_Specification.md`  
**内容**: 功能的完整设计规范，包括需求分析、技术架构、实现方案等
- 项目概述和设计目标
- 详细需求分析和用例场景  
- 技术架构设计
- 完整的实现方案
- 错误处理和性能考虑
- 兼容性说明

#### 02. 开发任务清单  
**文件**: `02_Development_TODO_List.md`  
**内容**: 分阶段的详细开发任务分解和时间估算
- 4个开发阶段规划 (基础架构 → 核心功能 → 用户体验 → 测试验证)
- 每个任务的详细说明和依赖关系
- 里程碑检查点和验收标准
- 开发注意事项和风险点
- **预估总开发时间**: 9-13天

#### 03. 功能测试检查清单
**文件**: `03_Feature_Test_Checklist.md`  
**内容**: 全面的功能测试检查清单和验收标准
- 基础功能测试 (拖拽操作、层级关系、数据持久化)
- 边界情况测试 (循环引用、无效操作、大数据量)
- 用户体验测试 (视觉反馈、交互体验、状态保持)
- 性能测试 (响应时间、资源使用)
- 兼容性和安全测试
- **预估测试时间**: 3-4天

## 🎯 项目概览

### 功能目标
实现 Evernote Mac 应用标签模块的拖拽功能，允许用户通过拖拽操作重新组织标签的层级结构。

### 核心特性
- ✅ **层级重组**: 支持拖拽改变标签父子关系
- ✅ **循环引用防护**: 自动检查并阻止循环嵌套
- ✅ **排序兼容**: 保持现有的按名称/笔记数排序逻辑
- ✅ **所有标签类型**: 支持本地、企业、共享标签
- ✅ **数据同步**: 复用现有的同步机制
- ❌ **同级排序**: 不支持手动调整同级标签顺序

### 技术方案
- **UI层**: 扩展 `TagListOutlineView` 支持拖拽操作
- **数据层**: 利用现有的 `ENUniqueTag.setParent()` 方法
- **协调层**: 在 `TagListDataSource` 中实现拖拽逻辑和验证
- **同步层**: 复用现有的数据同步和通知机制

## 🚀 快速开始

### 开发准备
1. 阅读 `01_Tag_DragDrop_Design_Specification.md` 了解完整设计
2. 查看 `02_Development_TODO_List.md` 制定开发计划
3. 按照 Phase 1 → Phase 2 → Phase 3 → Phase 4 的顺序进行开发

### 关键文件位置
```
Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Tags Module New/
├── TagList/
│   ├── TagListOutlineView.swift          # 主要修改文件
│   ├── TagListDataSource.swift           # 主要修改文件  
│   ├── TagListViewController.swift       # 无需修改
│   └── TagListCellView.swift            # 无需修改
├── EN4TagTreeController.h/.m             # 无需修改
└── (新增) TagDragDropConstants.swift     # 新增文件
```

### 测试验证
1. 参考 `03_Feature_Test_Checklist.md` 进行全面测试
2. 重点关注循环引用防护和性能表现
3. 确保与现有功能的兼容性

## 📊 项目时间线

```
开发阶段                   预估时间    主要任务
├─ Phase 1: 基础架构       2-3天       拖拽类型定义、UI注册、基础功能
├─ Phase 2: 核心功能       3-4天       验证逻辑、数据更新、UI刷新
├─ Phase 3: 用户体验       2-3天       视觉反馈、动画效果、错误处理
└─ Phase 4: 测试验证       2-3天       全面测试、性能优化、Bug修复
```

**总计**: 9-13天开发 + 3-4天测试 = **12-17天**

## 🎨 设计原则

### 用户体验
- **直观性**: 拖拽操作符合用户直觉
- **一致性**: 与系统和应用的其他拖拽操作保持一致
- **反馈性**: 提供清晰的视觉和状态反馈
- **容错性**: 优雅处理错误和边界情况

### 技术实现
- **最小侵入**: 尽量复用现有代码和架构
- **高内聚**: 拖拽相关逻辑集中管理
- **低耦合**: 与现有功能保持松耦合
- **可维护**: 代码清晰易读，便于后续维护

## ⚠️ 重要注意事项

### 开发约束
1. **只支持层级改变**: 不支持同级标签的手动排序
2. **保持排序逻辑**: 拖拽后仍按用户选择的排序方式显示
3. **循环引用检查**: 必须严格防止标签层级循环
4. **性能要求**: 大量标签时仍需保持流畅体验

### 测试重点
1. **数据一致性**: 确保拖拽后数据同步正确
2. **用户体验**: 拖拽流畅度和视觉反馈
3. **边界情况**: 循环引用、网络异常等特殊情况
4. **兼容性**: 与现有功能的完美配合

### 风险控制
1. **代码Review**: 所有修改需要thorough review
2. **分阶段测试**: 每个Phase完成后进行测试
3. **回归测试**: 确保不影响现有功能
4. **性能监控**: 关注内存和CPU使用情况

---

## 📞 联系信息

如有疑问或需要澄清，请联系：
- **项目负责人**: [项目负责人信息]
- **技术负责人**: [技术负责人信息]
- **测试负责人**: [测试负责人信息]

**文档创建日期**: 2025-11-21  
**文档版本**: v1.0  
**预计完成日期**: [根据开发开始时间 + 12-17天]