# Evernote Mac AI Area 开发 TODO 清单

## 项目开发阶段划分

### Phase 1: 基础架构搭建 🏗️
**目标**: 建立核心的 AI 容器架构和基础设施

#### Phase 1.1: 核心组件创建
- [ ] **创建 ENModuleAIContainerViewController**
  - [ ] 创建头文件 `ENModuleAIContainerViewController.h`
  - [ ] 创建实现文件 `ENModuleAIContainerViewController.m`
  - [ ] 创建 XIB 文件 `ENModuleAIContainerViewController.xib`
  - [ ] 实现基础的 `initWithModule:accountController:` 方法
  - [ ] 实现 NSSplitViewDelegate 协议

- [ ] **扩展 ENBaseViewModule**
  - [ ] 在 `ENBaseViewModule.h` 中添加 AI 相关属性和方法声明
  - [ ] 在 `ENBaseViewModule.m` 中实现默认的 AI 支持方法
  - [ ] 添加 `aiContainerViewController` 属性的 getter/setter
  - [ ] 实现 `showAIArea:`, `toggleAIArea` 等实例方法

- [ ] **创建 AI Container 目录结构**
  - [ ] 在 View Modules 下创建 `AI Container` 目录
  - [ ] 组织文件结构：头文件、实现文件、XIB 文件

#### Phase 1.2: XIB 界面设计
- [ ] **设计 ENModuleAIContainerViewController.xib**
  - [ ] 添加主容器视图 (Container View)
  - [ ] 添加 NSSplitView 组件
  - [ ] 配置左侧模块容器 (moduleContainerView)
  - [ ] 配置右侧 AI 容器 (aiContainerView)
  - [ ] 设置自动布局约束
  - [ ] 连接 IBOutlet 属性

- [ ] **配置 NSSplitView 属性**
  - [ ] 设置分割线样式 (dividerStyle = thin)
  - [ ] 设置垂直分割 (vertical = YES)
  - [ ] 配置子视图优先级 (holdingPriorities)
  - [ ] 连接 delegate 到 File's Owner

#### Phase 1.3: 分割视图功能实现
- [ ] **实现 NSSplitViewDelegate 方法**
  - [ ] `splitView:canCollapseSubview:` - 只允许 AI 区域折叠
  - [ ] `splitView:constrainMinCoordinate:ofSubviewAt:` - 模块最小宽度 400px
  - [ ] `splitView:constrainMaxCoordinate:ofSubviewAt:` - AI 区域最小宽度 200px
  - [ ] `splitViewDidResizeSubviews:` - 实时保存 AI 区域宽度

- [ ] **实现布局控制方法**
  - [ ] `showAIArea:animated:` - 显示/隐藏 AI 区域
  - [ ] `toggleAIArea` - 切换 AI 区域显示状态
  - [ ] `setAIAreaWidth:animated:` - 设置 AI 区域宽度

### Phase 2: 模块集成和配置 🔧
**目标**: 为指定的三个模块添加 AI 支持配置

#### Phase 2.1: Notes Module 集成
- [ ] **修改 EN4NotesModule**
  - [ ] 在 `EN4NotesModule.m` 中重写 `supportsAIArea` 返回 YES
  - [ ] 重写 `shouldShowAIAreaByDefault` 返回 YES
  - [ ] 重写 `defaultAIAreaWidth` 返回 300.0f
  - [ ] 测试 Notes Module 的 AI 容器创建

- [ ] **验证 Notes Module 集成**
  - [ ] 确认切换到 Notes Module 时创建 AI 容器
  - [ ] 验证 AI 区域的显示/隐藏功能
  - [ ] 测试拖拽调整 AI 区域宽度
  - [ ] 检查响应链是否正常工作

#### Phase 2.2: Tasks Module 集成
- [ ] **修改 TaskViewModule**
  - [ ] 确认 TaskViewModule 文件位置和语言 (Swift/ObjC)
  - [ ] 重写 `supportsAIArea` 返回 YES
  - [ ] 重写 `shouldShowAIAreaByDefault` 返回 YES
  - [ ] 重写 `defaultAIAreaWidth` 返回 280.0f

- [ ] **验证 Tasks Module 集成**
  - [ ] 测试从 Notes 切换到 Tasks 的 AI 状态管理
  - [ ] 验证 Tasks Module 的独立 AI 配置
  - [ ] 检查状态持久化是否正确工作

#### Phase 2.3: Library Module 集成
- [ ] **修改 ENLibraryViewModule**
  - [ ] 重写 `supportsAIArea` 返回 YES
  - [ ] 重写 `shouldShowAIAreaByDefault` 返回 NO (默认隐藏)
  - [ ] 重写 `defaultAIAreaWidth` 返回 320.0f

- [ ] **验证 Library Module 集成**
  - [ ] 确认 Library Module 默认隐藏 AI 区域
  - [ ] 测试手动开启 AI 功能
  - [ ] 验证宽度配置 (320px) 是否正确应用

### Phase 3: 窗口控制器修改 🏠
**目标**: 修改主窗口控制器以支持 AI 容器的管理

#### Phase 3.1: 修改模块切换逻辑
- [ ] **修改 ENNoteCollectionWindowController+ViewModules.m**
  - [ ] 修改 `setModule:` 方法以支持 AI 容器
  - [ ] 实现 AI 容器的懒加载逻辑
  - [ ] 处理容器和原始模块的视图添加
  - [ ] 正确处理 previousModule 的清理

- [ ] **修改响应链处理**
  - [ ] 修改 `updateResponderChain` 方法
  - [ ] 处理容器和包装模块的响应链设置
  - [ ] 确保初始响应者正确设置

#### Phase 3.2: 修改 currentModule 和 previousModule 逻辑
- [ ] **实现智能返回逻辑**
  - [ ] 修改 `currentModule` 方法返回包装的模块而非容器
  - [ ] 修改 `previousModule` 方法返回包装的模块而非容器
  - [ ] 添加 `currentViewController` 方法返回实际的视图控制器

- [ ] **处理生命周期方法**
  - [ ] 确保包装的模块收到正确的生命周期通知
  - [ ] 处理容器的生命周期方法转发
  - [ ] 验证模块切换时的方法调用顺序

### Phase 4: 状态持久化实现 💾
**目标**: 实现 AI 区域状态的保存和恢复

#### Phase 4.1: 偏好设置系统
- [ ] **定义偏好设置键**
  - [ ] 创建 `ENAIAreaVisibleKey` 宏定义
  - [ ] 创建 `ENAIAreaWidthKey` 宏定义
  - [ ] 确保键名格式：`EN{ModuleID}AIAreaVisible/Width`

- [ ] **实现状态管理方法**
  - [ ] `saveLayoutState` - 保存当前布局状态
  - [ ] `restoreLayoutState` - 恢复保存的布局状态
  - [ ] 处理首次启动时的默认值

#### Phase 4.2: 状态恢复逻辑
- [ ] **实现恢复逻辑**
  - [ ] 在容器创建时自动调用状态恢复
  - [ ] 区分首次使用和恢复保存状态
  - [ ] 使用模块的默认设置作为回退

- [ ] **验证状态持久化**
  - [ ] 测试重启应用后状态是否正确恢复
  - [ ] 验证不同模块的独立状态管理
  - [ ] 检查状态保存的时机是否合适

### Phase 5: 容器消息转发实现 📤
**目标**: 确保 AI 容器正确转发消息到包装的模块

#### Phase 5.1: 生命周期方法转发
- [ ] **实现容器的生命周期方法**
  - [ ] `windowControllerWillShowContentView` 转发到包装模块
  - [ ] `windowControllerDidShowContentView` 转发到包装模块
  - [ ] `windowControllerWillHideContentView` 转发到包装模块
  - [ ] `windowControllerDidHideContentView` 转发到包装模块

#### Phase 5.2: 消息转发机制
- [ ] **实现 NSObject 消息转发**
  - [ ] `forwardInvocation:` - 转发调用到包装的模块
  - [ ] `methodSignatureForSelector:` - 返回包装模块的方法签名
  - [ ] `respondsToSelector:` - 检查容器和包装模块的响应能力

- [ ] **验证消息转发**
  - [ ] 测试菜单命令是否正确传递
  - [ ] 验证快捷键是否正常工作
  - [ ] 检查工具栏按钮点击是否正确响应

### Phase 6: 工具栏集成 🔧
**目标**: 在主工具栏添加 AI 切换功能

#### Phase 6.1: AI 切换按钮
- [ ] **添加工具栏按钮**
  - [ ] 在主工具栏 XIB 中添加 AI 切换按钮
  - [ ] 设置按钮图标和标题
  - [ ] 连接 IBAction 到控制器

- [ ] **实现按钮逻辑**
  - [ ] `toggleCurrentModuleAIArea:` - 切换当前模块的 AI 区域
  - [ ] `updateAIToggleButtonState` - 更新按钮状态
  - [ ] 根据模块 AI 支持情况显示/隐藏按钮

#### Phase 6.2: 快捷键支持
- [ ] **添加快捷键处理**
  - [ ] 在 `keyDown:` 方法中添加 Cmd+Shift+A 处理
  - [ ] 实现快捷键的 AI 区域切换功能
  - [ ] 更新菜单项以显示快捷键

### Phase 7: AICopilotViewController 集成 🤖
**目标**: 集成现有的 AI 功能到容器中

#### Phase 7.1: AI 视图控制器集成
- [ ] **在容器中集成 AICopilotViewController**
  - [ ] 在容器初始化时创建 AICopilotViewController
  - [ ] 将 AI 视图控制器的视图添加到 aiContainerView
  - [ ] 设置正确的 type 参数 (AICopilotTypeModule)

- [ ] **验证 AI 功能**
  - [ ] 确认 AI 聊天功能正常工作
  - [ ] 测试 AI 写作功能
  - [ ] 验证 AI 文件处理功能

#### Phase 7.2: AI 和编辑器交互
- [ ] **验证 AI 与编辑器的交互**
  - [ ] 测试 AI 内容插入到编辑器
  - [ ] 验证编辑器内容传递给 AI
  - [ ] 检查文件上传和处理功能

### Phase 8: 内存管理和性能优化 ⚡
**目标**: 确保良好的内存管理和性能表现

#### Phase 8.1: 内存管理
- [ ] **实现清理方法**
  - [ ] 在 ENBaseViewModule 的 dealloc 中清理 AI 容器
  - [ ] 在容器的 cleanup 方法中清理 AI 视图控制器
  - [ ] 正确处理响应链的清理

- [ ] **验证内存管理**
  - [ ] 使用 Instruments 检查内存泄漏
  - [ ] 验证模块切换时的内存释放
  - [ ] 检查 AI 组件的内存占用

#### Phase 8.2: 性能优化
- [ ] **实现懒加载优化**
  - [ ] 确保 AI 容器只在需要时创建
  - [ ] AICopilotViewController 的延迟实例化
  - [ ] 状态恢复的性能优化

- [ ] **验证性能表现**
  - [ ] 测试应用启动速度影响
  - [ ] 验证模块切换的流畅性
  - [ ] 检查 AI 区域显示/隐藏的动画性能

### Phase 9: 错误处理和健壮性 🛡️
**目标**: 增强系统的错误处理和容错能力

#### Phase 9.1: 参数验证和错误处理
- [ ] **添加参数验证**
  - [ ] 在容器初始化时验证参数有效性
  - [ ] 检查模块是否支持 AI 功能
  - [ ] 处理 AICopilotViewController 创建失败的情况

- [ ] **添加日志和监控**
  - [ ] 添加关键操作的日志记录
  - [ ] 实现错误情况的监控和报告
  - [ ] 添加调试模式的详细日志

#### Phase 9.2: 异常情况处理
- [ ] **处理边缘情况**
  - [ ] 处理窗口大小过小的情况
  - [ ] 处理模块快速切换的情况
  - [ ] 处理 AI 服务不可用的情况

### Phase 10: 测试和验证 🧪
**目标**: 全面测试功能的正确性和稳定性

#### Phase 10.1: 功能测试
- [ ] **基础功能测试**
  - [ ] 测试 AI 区域的显示/隐藏
  - [ ] 验证拖拽调整宽度功能
  - [ ] 测试状态的保存和恢复

- [ ] **模块切换测试**
  - [ ] 测试在支持 AI 的模块间切换
  - [ ] 验证从支持 AI 的模块切换到不支持的模块
  - [ ] 测试从不支持 AI 的模块切换到支持的模块

#### Phase 10.2: 兼容性测试
- [ ] **响应链兼容性**
  - [ ] 验证菜单命令正确传递
  - [ ] 测试快捷键功能
  - [ ] 检查工具栏按钮响应

- [ ] **API 兼容性**
  - [ ] 验证 `self.notesModule` 等访问方式正常工作
  - [ ] 测试 `self.currentModule` 返回正确的模块
  - [ ] 检查现有代码的兼容性

#### Phase 10.3: 性能和压力测试
- [ ] **性能基准测试**
  - [ ] 测试启动时间影响
  - [ ] 验证内存使用情况
  - [ ] 检查 CPU 使用率

- [ ] **压力测试**
  - [ ] 频繁切换模块的稳定性测试
  - [ ] 长时间运行的内存泄漏测试
  - [ ] 大量数据下的性能测试

## 检查点 (Checkpoints) ✅

### Checkpoint 1: 基础架构完成
**验证标准**:
- [ ] ENModuleAIContainerViewController 类创建完成且可以编译
- [ ] XIB 文件正确连接且界面正常显示
- [ ] NSSplitView 基础功能工作正常
- [ ] ENBaseViewModule 扩展方法实现完成

### Checkpoint 2: Notes Module 集成成功
**验证标准**:
- [ ] Notes Module 显示 AI 容器
- [ ] 可以正常切换 AI 区域显示/隐藏
- [ ] 拖拽调整宽度功能正常
- [ ] 响应链工作正常，菜单和快捷键有效

### Checkpoint 3: 三个模块全部集成
**验证标准**:
- [ ] Notes、Tasks、Library 三个模块都正确支持 AI
- [ ] 每个模块的默认配置正确应用
- [ ] 模块间切换时 AI 状态独立管理
- [ ] 不支持 AI 的模块完全不受影响

### Checkpoint 4: 状态持久化工作
**验证标准**:
- [ ] 重启应用后 AI 区域状态正确恢复
- [ ] 不同模块的状态独立保存和恢复
- [ ] 首次使用时应用正确的默认设置
- [ ] 状态保存的时机合适，不影响性能

### Checkpoint 5: 完整功能验证
**验证标准**:
- [ ] 所有 AI 功能正常工作 (聊天、写作、文件处理)
- [ ] 工具栏 AI 切换按钮工作正常
- [ ] 快捷键 Cmd+Shift+A 功能正常
- [ ] 消息转发机制工作正确

### Checkpoint 6: 性能和稳定性达标
**验证标准**:
- [ ] 内存使用合理，无明显泄漏
- [ ] 启动性能影响在可接受范围内
- [ ] 模块切换流畅，无卡顿
- [ ] 压力测试通过，长时间运行稳定

## 风险缓解措施 ⚠️

### 高风险项及缓解措施

1. **响应链断裂**
   - **缓解**: 实现完整的消息转发机制
   - **验证**: 测试所有菜单命令和快捷键
   - **回退**: 提供快速禁用 AI 容器的开关

2. **内存泄漏**
   - **缓解**: 实现严格的生命周期管理
   - **验证**: 使用 Instruments 进行内存分析
   - **监控**: 添加内存使用监控

3. **状态同步问题**
   - **缓解**: 集中化状态管理
   - **验证**: 全面测试状态保存和恢复
   - **降级**: 提供重置状态的功能

### 开发过程中的质量保证

1. **代码审查**
   - 每个 Phase 完成后进行代码审查
   - 重点关注内存管理和线程安全
   - 确保代码风格一致性

2. **增量测试**
   - 每个功能完成后立即测试
   - 不等到所有功能完成再进行集成测试
   - 及时发现和修复问题

3. **文档更新**
   - 随着开发进展更新设计文档
   - 记录重要的设计决策和变更
   - 维护开发者友好的注释

## 发布策略 🚀

### 内部测试阶段
- [ ] 开发团队内部验证所有功能
- [ ] 性能基准测试和对比
- [ ] 内存和稳定性测试

### Alpha 测试阶段
- [ ] 公司内部用户测试
- [ ] 收集用户反馈
- [ ] 修复发现的问题

### Beta 测试阶段
- [ ] 外部用户测试
- [ ] 大规模数据测试
- [ ] 最终性能优化

### 正式发布
- [ ] 功能开关控制
- [ ] 渐进式推出
- [ ] 监控关键指标

---

**总计: 约 100+ 个具体任务项**
**预估开发时间: 4-6 周**
**关键里程碑: 6 个主要检查点**