# Evernote Mac AI Area 开发任务拆分

## 按功能模块结构拆分

### 1. 核心架构 🏗️

#### 1.1 基础容器组件
- **创建ENModuleAIContainerViewController类**
  - 创建头文件 `ENModuleAIContainerViewController.h`
  - 创建实现文件 `ENModuleAIContainerViewController.m`
  - 实现基础的 `initWithModule:accountController:` 方法
  - 实现基本的生命周期管理

- **XIB界面文件创建**
  - 创建 `ENModuleAIContainerViewController.xib` 文件
  - 设计主容器视图布局
  - 配置自动布局约束
  - 连接IBOutlet属性到代码

- **NSSplitView分割视图配置**
  - 添加NSSplitView组件到XIB
  - 配置左侧模块容器 (moduleContainerView)
  - 配置右侧AI容器 (aiContainerView)
  - 设置分割线样式和属性

#### 1.2 基础模块扩展
- **扩展ENBaseViewModule**
  - 在头文件中添加AI相关属性声明
  - 添加 `aiContainerViewController` 属性
  - 声明 `supportsAIArea`, `shouldShowAIAreaByDefault`, `defaultAIAreaWidth` 方法
  - 声明 `showAIArea:`, `toggleAIArea` 实例方法

- **实现ENBaseViewModule AI支持方法**
  - 实现默认的AI支持方法（返回NO）
  - 实现 `aiContainerViewController` 属性的getter/setter
  - 实现 `showAIArea:animated:` 方法
  - 实现 `toggleAIArea` 方法

#### 1.3 目录结构组织
- **创建AI Container目录**
  - 在View Modules下创建 `AI Container` 目录
  - 组织头文件、实现文件、XIB文件结构
  - 更新项目文件引用

### 2. 分割视图功能 ⚡

#### 2.1 NSSplitViewDelegate实现
- **约束控制方法**
  - `splitView:canCollapseSubview:` - 只允许AI区域折叠
  - `splitView:constrainMinCoordinate:ofSubviewAt:` - 模块最小宽度400px
  - `splitView:constrainMaxCoordinate:ofSubviewAt:` - AI区域最小宽度200px
  - `splitView:shouldCollapseSubview:forDoubleClickOnDividerAtIndex:` - 双击折叠

- **实时响应方法**
  - `splitViewDidResizeSubviews:` - 实时保存AI区域宽度
  - `splitView:effectiveRect:forDrawnRect:ofDividerAtIndex:` - 分割线绘制
  - `splitView:additionalEffectiveRectOfDividerAtIndex:` - 分割线响应区域

#### 2.2 布局控制功能
- **显示隐藏控制**
  - `showAIArea:animated:` - 显示/隐藏AI区域（带动画）
  - `hideAIArea:animated:` - 隐藏AI区域
  - `toggleAIArea` - 切换AI区域显示状态
  - `isAIAreaVisible` - 检查AI区域可见性

- **尺寸控制**
  - `setAIAreaWidth:animated:` - 设置AI区域宽度
  - `getAIAreaWidth` - 获取当前AI区域宽度
  - `restoreDefaultAIAreaWidth` - 恢复默认宽度
  - `constrainAIAreaWidth:` - 约束宽度在合理范围内

#### 2.3 动画效果
- **平滑动画实现**
  - 实现分割视图位置变化的平滑动画
  - 处理动画过程中的用户交互
  - 优化动画性能，避免卡顿
  - 提供动画完成回调

### 3. 模块集成 🔗

#### 3.1 Notes Module集成
- **重写AI支持方法**
  - 重写 `supportsAIArea` 返回 YES
  - 重写 `shouldShowAIAreaByDefault` 返回 YES
  - 重写 `defaultAIAreaWidth` 返回 300.0f
  - 添加Notes特定的AI配置

- **功能验证**
  - 测试Notes Module的AI容器创建
  - 验证AI区域的显示/隐藏功能
  - 测试拖拽调整AI区域宽度
  - 检查响应链是否正常工作

#### 3.2 Tasks Module集成
- **确认文件位置和语言**
  - 确认TaskViewModule文件位置
  - 确认是Swift还是ObjC实现
  - 查看现有的模块结构
  - 准备相应的集成方案

- **实现AI支持**
  - 重写 `supportsAIArea` 返回 YES
  - 重写 `shouldShowAIAreaByDefault` 返回 YES
  - 重写 `defaultAIAreaWidth` 返回 280.0f
  - 处理Swift/ObjC混合开发问题

- **状态管理验证**
  - 测试从Notes切换到Tasks的AI状态管理
  - 验证Tasks Module的独立AI配置
  - 检查状态持久化是否正确工作

#### 3.3 Library Module集成
- **实现特殊配置**
  - 重写 `supportsAIArea` 返回 YES
  - 重写 `shouldShowAIAreaByDefault` 返回 NO（默认隐藏）
  - 重写 `defaultAIAreaWidth` 返回 320.0f
  - 实现Library特定的AI行为

- **默认隐藏逻辑验证**
  - 确认Library Module默认隐藏AI区域
  - 测试手动开启AI功能
  - 验证宽度配置(320px)是否正确应用
  - 测试状态记忆功能

### 4. 窗口控制器集成 🏠

#### 4.1 模块切换逻辑修改
- **修改setModule方法**
  - 在 `ENNoteCollectionWindowController+ViewModules.m` 中修改 `setModule:` 方法
  - 实现AI容器的懒加载逻辑
  - 处理容器和原始模块的视图添加
  - 正确处理previousModule的清理

- **智能容器管理**
  - 判断模块是否支持AI功能
  - 创建或复用AI容器
  - 处理不支持AI模块的直接加载
  - 实现容器的生命周期管理

#### 4.2 响应链处理
- **修改响应链逻辑**
  - 修改 `updateResponderChain` 方法
  - 处理容器和包装模块的响应链设置
  - 确保初始响应者正确设置
  - 处理菜单命令的正确传递

- **方法转发实现**
  - 实现 `forwardInvocation:` 方法
  - 实现 `methodSignatureForSelector:` 方法
  - 实现 `respondsToSelector:` 方法
  - 确保所有消息正确转发到包装模块

#### 4.3 属性访问兼容性
- **智能返回逻辑**
  - 修改 `currentModule` 方法返回包装的模块而非容器
  - 修改 `previousModule` 方法返回包装的模块而非容器
  - 添加 `currentViewController` 方法返回实际的视图控制器
  - 保持现有API的兼容性

### 5. 状态管理 💾

#### 5.1 偏好设置系统
- **定义偏好设置键**
  - 创建 `ENAIAreaVisibleKey` 宏定义
  - 创建 `ENAIAreaWidthKey` 宏定义
  - 确保键名格式：`EN{ModuleID}AIAreaVisible/Width`
  - 定义默认值常量

- **状态管理方法**
  - `saveLayoutState` - 保存当前布局状态
  - `restoreLayoutState` - 恢复保存的布局状态
  - `resetLayoutState` - 重置为默认状态
  - 处理首次启动时的默认值

#### 5.2 状态持久化实现
- **实现恢复逻辑**
  - 在容器创建时自动调用状态恢复
  - 区分首次使用和恢复保存状态
  - 使用模块的默认设置作为回退
  - 处理配置文件损坏的情况

- **实时状态同步**
  - 在用户操作时实时保存状态
  - 优化保存频率，避免性能影响
  - 实现防抖动机制
  - 处理快速操作时的状态一致性

#### 5.3 跨模块状态管理
- **独立状态管理**
  - 确保每个模块的AI状态独立保存
  - 实现模块间状态隔离
  - 处理模块卸载时的状态清理
  - 支持模块特定的状态配置

### 6. AI功能集成 🤖

#### 6.1 AICopilotViewController集成
- **AI视图控制器创建**
  - 在容器初始化时创建AICopilotViewController
  - 将AI视图控制器的视图添加到aiContainerView
  - 设置正确的type参数(AICopilotTypeModule)
  - 处理AI组件的生命周期

- **AI功能验证**
  - 确认AI聊天功能正常工作
  - 测试AI写作功能
  - 验证AI文件处理功能
  - 检查AI响应速度和稳定性

#### 6.2 AI与编辑器交互
- **内容交互验证**
  - 测试AI内容插入到编辑器
  - 验证编辑器内容传递给AI
  - 检查文件上传和处理功能
  - 测试复制粘贴功能

- **上下文感知**
  - 实现AI对当前笔记内容的感知
  - 支持选中文本的AI处理
  - 实现AI建议的智能插入
  - 处理格式保持和转换

### 7. 用户界面控制 🎛️

#### 7.1 工具栏集成
- **AI切换按钮**
  - 在主工具栏XIB中添加AI切换按钮
  - 设置按钮图标和标题
  - 连接IBAction到控制器
  - 实现按钮状态的动态更新

- **按钮逻辑实现**
  - `toggleCurrentModuleAIArea:` - 切换当前模块的AI区域
  - `updateAIToggleButtonState` - 更新按钮状态
  - 根据模块AI支持情况显示/隐藏按钮
  - 处理按钮的启用/禁用状态

#### 7.2 快捷键支持
- **快捷键处理**
  - 在 `keyDown:` 方法中添加Cmd+Shift+A处理
  - 实现快捷键的AI区域切换功能
  - 更新菜单项以显示快捷键
  - 处理快捷键冲突

- **菜单集成**
  - 在相关菜单中添加AI切换选项
  - 实现菜单项的状态更新
  - 添加快捷键显示
  - 处理菜单项的启用/禁用

### 8. 性能优化 ⚡

#### 8.1 内存管理
- **生命周期管理**
  - 在ENBaseViewModule的dealloc中清理AI容器
  - 在容器的cleanup方法中清理AI视图控制器
  - 正确处理响应链的清理
  - 实现强引用循环的检测和避免

- **内存监控**
  - 使用Instruments检查内存泄漏
  - 验证模块切换时的内存释放
  - 检查AI组件的内存占用
  - 实现内存警告的处理

#### 8.2 懒加载优化
- **延迟实例化**
  - 确保AI容器只在需要时创建
  - AICopilotViewController的延迟实例化
  - 状态恢复的性能优化
  - 减少启动时的内存占用

- **性能基准测试**
  - 测试应用启动速度影响
  - 验证模块切换的流畅性
  - 检查AI区域显示/隐藏的动画性能
  - 进行压力测试和长时间运行测试

### 9. 错误处理与健壮性 🛡️

#### 9.1 参数验证和错误处理
- **输入验证**
  - 在容器初始化时验证参数有效性
  - 检查模块是否支持AI功能
  - 处理AICopilotViewController创建失败的情况
  - 实现降级处理机制

- **异常处理**
  - 添加关键操作的异常捕获
  - 实现错误情况的用户友好提示
  - 添加错误恢复机制
  - 记录错误日志便于调试

#### 9.2 边缘情况处理
- **特殊场景处理**
  - 处理窗口大小过小的情况
  - 处理模块快速切换的情况
  - 处理AI服务不可用的情况
  - 处理网络连接问题

- **容错机制**
  - 实现状态损坏时的自动修复
  - 提供重置到默认状态的功能
  - 处理配置文件版本兼容性
  - 实现优雅降级

### 10. 测试验证 🧪

#### 10.1 功能测试
- **基础功能验证**
  - 测试AI区域的显示/隐藏
  - 验证拖拽调整宽度功能
  - 测试状态的保存和恢复
  - 检查动画效果的流畅性

- **模块切换测试**
  - 测试在支持AI的模块间切换
  - 验证从支持AI的模块切换到不支持的模块
  - 测试从不支持AI的模块切换到支持的模块
  - 检查状态持久化的正确性

#### 10.2 兼容性测试
- **响应链兼容性**
  - 验证菜单命令正确传递
  - 测试快捷键功能
  - 检查工具栏按钮响应
  - 验证第一响应者处理

- **API兼容性**
  - 验证 `self.notesModule` 等访问方式正常工作
  - 测试 `self.currentModule` 返回正确的模块
  - 检查现有代码的兼容性
  - 验证插件系统的兼容性

#### 10.3 性能和压力测试
- **性能基准**
  - 测试启动时间影响
  - 验证内存使用情况
  - 检查CPU使用率
  - 测量UI响应时间

- **压力测试**
  - 频繁切换模块的稳定性测试
  - 长时间运行的内存泄漏测试
  - 大量数据下的性能测试
  - 并发操作的稳定性测试

## 验收标准检查点 ✅

### Checkpoint 1: 基础架构完成
- [ ] ENModuleAIContainerViewController类创建完成且可以编译
- [ ] XIB文件正确连接且界面正常显示
- [ ] NSSplitView基础功能工作正常
- [ ] ENBaseViewModule扩展方法实现完成

### Checkpoint 2: Notes Module集成成功
- [ ] Notes Module显示AI容器
- [ ] 可以正常切换AI区域显示/隐藏
- [ ] 拖拽调整宽度功能正常
- [ ] 响应链工作正常，菜单和快捷键有效

### Checkpoint 3: 三个模块全部集成
- [ ] Notes、Tasks、Library三个模块都正确支持AI
- [ ] 每个模块的默认配置正确应用
- [ ] 模块间切换时AI状态独立管理
- [ ] 不支持AI的模块完全不受影响

### Checkpoint 4: 状态持久化工作
- [ ] 重启应用后AI区域状态正确恢复
- [ ] 不同模块的状态独立保存和恢复
- [ ] 首次使用时应用正确的默认设置
- [ ] 状态保存的时机合适，不影响性能

### Checkpoint 5: 完整功能验证
- [ ] 所有AI功能正常工作(聊天、写作、文件处理)
- [ ] 工具栏AI切换按钮工作正常
- [ ] 快捷键Cmd+Shift+A功能正常
- [ ] 消息转发机制工作正确

### Checkpoint 6: 性能和稳定性达标
- [ ] 内存使用合理，无明显泄漏
- [ ] 启动性能影响在可接受范围内
- [ ] 模块切换流畅，无卡顿
- [ ] 压力测试通过，长时间运行稳定

## 开发优先级建议

### 高优先级 (P0)
1. 核心架构 - 基础容器组件
2. 分割视图功能 - NSSplitViewDelegate实现
3. Notes Module集成 - 作为主要测试模块

### 中优先级 (P1)
4. 窗口控制器集成 - 模块切换逻辑
5. 状态管理 - 偏好设置系统
6. AI功能集成 - AICopilotViewController集成

### 低优先级 (P2)
7. Tasks和Library Module集成
8. 用户界面控制 - 工具栏和快捷键
9. 性能优化和错误处理
10. 全面测试验证

**预估开发时间**: 4-6周
**关键里程碑**: 6个主要检查点
**总任务数**: 约120+个具体任务项