# Evernote Mac AI Area 共享容器重构 TODO 清单

## 项目概述
将当前每个模块独立的AI容器架构重构为共享AI容器架构，解决AI状态不一致和宽度不统一的问题。

## 开发阶段规划

### Phase 1: 核心架构重构 🏗️ 
**目标**: 实现共享AI容器的核心架构

#### Phase 1.1: 窗口控制器层面修改
- [ ] **修改 ENNoteCollectionWindowController+ViewModules.h**
  - [ ] 添加 `@property (strong, readonly) ENModuleAIContainerViewController *sharedAIContainer;`
  - [ ] 添加 `- (void)createSharedAIContainerIfNeeded;` 方法声明
  - [ ] 添加 `- (void)hideSharedAIContainerIfNeeded;` 方法声明

- [ ] **修改 ENNoteCollectionWindowControllerPrivate.h**
  - [ ] 添加 `@property (strong) ENModuleAIContainerViewController *sharedAIContainer;` 私有属性
  - [ ] 确保不与现有属性冲突

#### Phase 1.2: setModule: 方法核心重构
- [ ] **重构 setModule: 方法 (ENNoteCollectionWindowController+ViewModules.m:142-159)**
  - [ ] 🔥 **关键修改**: 将独立AI容器创建逻辑改为共享容器逻辑
  - [ ] 替换 `module.aiContainerViewController` 创建逻辑
  - [ ] 实现 `[self createSharedAIContainerIfNeeded]` 调用
  - [ ] 实现 `[self.sharedAIContainer switchToModule:module animated:YES]` 调用
  - [ ] 保持支持AI模块的检查逻辑（为未来预留不支持AI的模块）

- [ ] **实现共享容器管理方法**
  - [ ] 实现 `createSharedAIContainerIfNeeded` 方法
  - [ ] 实现 `hideSharedAIContainerIfNeeded` 方法
  - [ ] 确保容器只创建一次且状态保持

#### Phase 1.3: ENModuleAIContainerViewController 重构
- [ ] **修改 ENModuleAIContainerViewController.h**
  - [ ] 将 `@property (weak) ENBaseViewModule *wrappedModule;` 改为 `@property (weak) ENBaseViewModule *currentModule;`
  - [ ] 修改构造方法：`initWithAccountController:` (移除module参数)
  - [ ] 添加 `- (void)switchToModule:(ENBaseViewModule *)module animated:(BOOL)animated;` 方法声明

- [ ] **实现模块切换逻辑**
  - [ ] 实现 `switchToModule:animated:` 方法
  - [ ] 处理前一个模块的隐藏和生命周期
  - [ ] 处理新模块的显示和生命周期
  - [ ] 实现模块切换动画
  - [ ] 更新约束管理

- [ ] **重构消息转发机制**
  - [ ] 修改 `forwardInvocation:` 转发到 `currentModule`
  - [ ] 修改 `methodSignatureForSelector:` 获取当前模块签名
  - [ ] 修改 `respondsToSelector:` 检查当前模块响应能力

### Phase 2: 清理和优化 🧹
**目标**: 清理旧架构代码，优化新架构

#### Phase 2.1: ENBaseViewModule 清理
- [ ] **修改 ENBaseViewModule.h**
  - [ ] 🗑️ 移除 `@property (strong) ENModuleAIContainerViewController *aiContainerViewController;`
  - [ ] 🗑️ 移除 `- (void)showAIArea:(BOOL)show;` 方法声明
  - [ ] 🗑️ 移除 `- (void)toggleAIArea;` 方法声明
  - [ ] ✅ 保留 `+ (BOOL)supportsAIArea;` 方法声明（为未来灵活性）
  - [ ] 🗑️ 移除 `+ (BOOL)shouldShowAIAreaByDefault;` 和 `+ (CGFloat)defaultAIAreaWidth;`

- [ ] **修改 ENBaseViewModule.m**
  - [ ] 🗑️ 移除 aiContainerViewController 相关实例方法实现
  - [ ] ✅ 保留 `supportsAIArea` 默认实现，返回 YES
  - [ ] 🗑️ 移除其他AI配置类方法的默认实现
  - [ ] 确保基础模块功能不受影响

#### Phase 2.2: 模块代码部分清理
- [ ] **清理 EN4NotesModule**
  - [ ] ✅ 保持 `supportsAIArea` 使用基类默认实现
  - [ ] 🗑️ 移除 `shouldShowAIAreaByDefault` 和 `defaultAIAreaWidth` 方法
  - [ ] 🗑️ 移除任何直接操作 aiContainerViewController 的代码
  - [ ] 验证模块功能正常

- [ ] **清理 TaskViewModule**
  - [ ] ✅ 保持 `supportsAIArea` 使用基类默认实现
  - [ ] 🗑️ 移除其他AI配置方法重写
  - [ ] 🗑️ 移除任何直接操作 aiContainerViewController 的代码
  - [ ] 验证模块功能正常

- [ ] **清理 LibraryViewModule**
  - [ ] ✅ 保持 `supportsAIArea` 使用基类默认实现
  - [ ] 🗑️ 移除其他AI配置方法重写
  - [ ] 🗑️ 移除任何直接操作 aiContainerViewController 的代码
  - [ ] 验证模块功能正常

### Phase 3: 状态管理优化 💾
**目标**: 实现全局AI状态管理

#### Phase 3.1: 全局状态管理
- [ ] **定义全局偏好设置键**
  - [ ] 创建 `ENGlobalAIAreaVisibleKey` 常量
  - [ ] 创建 `ENGlobalAIAreaWidthKey` 常量
  - [ ] 🗑️ 移除所有基于moduleID的偏好设置键定义

- [ ] **重构状态保存逻辑**
  - [ ] 修改 `saveLayoutState` 方法使用全局键
  - [ ] 修改 `restoreLayoutState` 方法使用全局键
  - [ ] 实现首次使用时的默认宽度逻辑
  - [ ] 🗑️ 移除所有基于moduleID的状态保存逻辑

- [ ] **清理现有代码中的旧键使用**
  - [ ] 🗑️ 移除 `ENModuleAIContainerViewController.m` 中的 `ENAIAreaVisibleKey(moduleID)` 定义
  - [ ] 🗑️ 移除 `ENModuleAIContainerViewController.m` 中的 `ENAIAreaWidthKey(moduleID)` 定义
  - [ ] 🗑️ 移除所有基于moduleID的状态保存/恢复逻辑

#### Phase 3.2: 状态迁移处理
- [ ] **实现状态迁移**
  - [ ] 检测旧版本的模块级状态（Notes模块的设置）
  - [ ] 将Notes模块的旧状态迁移到全局状态
  - [ ] 清理所有旧的偏好设置键（各模块的ENAIAreaVisible/Width键）

### Phase 4: XIB文件更新 🎨
**目标**: 更新界面文件以匹配新架构

#### Phase 4.1: ENModuleAIContainerViewController.xib 更新
- [ ] **更新XIB文件连接**
  - [ ] 检查 moduleContainerView 连接 (之前可能叫 wrappedModuleView)
  - [ ] 确保 aiContainerView 连接正确
  - [ ] 验证约束设置合理

- [ ] **测试XIB兼容性**
  - [ ] 在不同Xcode版本中测试XIB文件
  - [ ] 确保界面布局正确显示
  - [ ] 验证约束在不同屏幕尺寸下工作正常

### Phase 5: 错误处理和健壮性 🛡️
**目标**: 增强系统稳定性

#### Phase 5.1: 参数验证和错误处理
- [ ] **添加参数验证**
  - [ ] 在 `switchToModule:` 中验证模块有效性
  - [ ] 检查模块是否支持AI功能
  - [ ] 处理空模块的情况

- [ ] **异常情况处理**
  - [ ] 处理AI容器创建失败
  - [ ] 处理模块切换过程中的异常
  - [ ] 实现降级方案（回退到不使用AI容器）

#### Phase 5.2: 日志和监控
- [ ] **添加调试日志**
  - [ ] 记录模块切换操作
  - [ ] 记录AI容器状态变化
  - [ ] 记录异常情况

### Phase 6: 兼容性测试 🧪
**目标**: 确保重构不破坏现有功能

#### Phase 6.1: 功能兼容性测试
- [ ] **基础功能测试**
  - [ ] 测试模块切换功能
  - [ ] 验证AI区域显示/隐藏
  - [ ] 测试AI功能正常工作

- [ ] **响应链兼容性测试**
  - [ ] 验证菜单命令正确传递
  - [ ] 测试快捷键功能
  - [ ] 检查工具栏按钮响应

- [ ] **API兼容性测试**
  - [ ] 验证 `self.currentModule` 返回正确模块
  - [ ] 测试现有代码的模块访问方式
  - [ ] 检查生命周期方法调用

#### Phase 6.2: 性能测试
- [ ] **内存使用测试**
  - [ ] 对比重构前后内存占用
  - [ ] 验证只创建一个AI容器实例
  - [ ] 检查模块切换时的内存变化

- [ ] **性能基准测试**
  - [ ] 测试模块切换速度
  - [ ] 验证AI区域显示性能
  - [ ] 检查启动时间影响

### Phase 7: 用户体验验证 ✨
**目标**: 验证重构达到预期用户体验

#### Phase 7.1: AI状态持续性验证
- [ ] **AI聊天历史测试**
  - [ ] 在Notes模块开始AI对话
  - [ ] 切换到Tasks模块验证历史保持
  - [ ] 继续对话验证上下文连续性

- [ ] **AI区域宽度一致性测试**
  - [ ] 在Notes模块调整AI区域宽度
  - [ ] 切换到其他模块验证宽度保持
  - [ ] 重启应用验证宽度持久化

#### Phase 7.2: 边缘情况测试
- [ ] **混合模块切换测试**
  - [ ] 从支持AI模块切换到不支持AI模块
  - [ ] 从不支持AI模块切换到支持AI模块
  - [ ] 验证AI容器正确显示/隐藏

- [ ] **快速切换测试**
  - [ ] 快速在多个模块间切换
  - [ ] 验证状态稳定性
  - [ ] 检查内存泄漏

## 检查点 (Checkpoints) ✅

### Checkpoint 1: 核心重构完成
**验证标准**:
- [ ] setModule: 方法成功重构，使用共享AI容器
- [ ] ENModuleAIContainerViewController 支持模块切换
- [ ] 至少一个模块(Notes)可以正常切换显示
- [ ] 编译无错误，基础功能可运行

**验证方法**:
```bash
# 编译测试
xcodebuild -workspace EverNote.xcworkspace -scheme Evernote -configuration Debug

# 功能测试
- 启动应用，切换到Notes模块
- 验证AI区域正常显示
- 切换到其他模块再切回Notes
```

### Checkpoint 2: 模块切换功能完整
**验证标准**:
- [ ] 三个目标模块(Notes/Tasks/Library)都支持AI容器切换
- [ ] 模块间切换流畅，无界面异常
- [ ] AI区域在支持和不支持AI的模块间正确显示/隐藏
- [ ] 消息转发和响应链工作正常

**验证方法**:
```bash
# 模块切换测试序列
Notes -> Tasks -> Library -> Messages -> Notes
验证每次切换的AI区域状态
```

### Checkpoint 3: 状态持续性达成
**验证标准**:
- [ ] AI聊天历史在模块切换时保持
- [ ] AI区域宽度在模块切换时保持一致
- [ ] 重启应用后AI状态正确恢复
- [ ] 不同模块的AI状态完全共享

**验证方法**:
```bash
# 状态持续性测试
1. 在Notes模块与AI对话，记录历史
2. 调整AI区域宽度到特定值
3. 切换到Tasks模块
4. 验证对话历史和宽度保持
5. 重启应用验证状态恢复
```

### Checkpoint 4: 代码清理完成
**验证标准**:
- [ ] ENBaseViewModule 中的旧AI容器代码完全移除
- [ ] 各模块代码清理完成，无遗留AI容器引用
- [ ] 全局状态管理正确实现
- [ ] 代码无编译警告

**验证方法**:
```bash
# 代码检查
grep -r "aiContainerViewController" Source/
# 应该只在窗口控制器相关文件中找到sharedAIContainer

# 编译检查
xcodebuild clean
xcodebuild -workspace EverNote.xcworkspace -scheme Evernote -configuration Debug
```

### Checkpoint 5: 兼容性验证通过
**验证标准**:
- [ ] 所有现有功能正常工作
- [ ] 响应链正确，菜单和快捷键有效
- [ ] 性能无明显降低
- [ ] 内存使用优化效果明显

**验证方法**:
```bash
# 兼容性测试
- 测试所有主要功能模块
- 验证菜单项和快捷键
- 使用Instruments检查内存使用
- 对比重构前后的性能指标
```

### Checkpoint 6: 用户体验目标达成
**验证标准**:
- [ ] AI状态在模块间完全连续
- [ ] 用户体验符合预期目标
- [ ] 无明显的性能或稳定性问题
- [ ] 准备发布测试

**验证方法**:
```bash
# 端到端用户场景测试
1. 模拟真实用户使用场景
2. 验证AI功能的连续性体验
3. 收集性能和稳定性数据
4. 准备内部测试发布
```

## 风险缓解措施 ⚠️

### 高风险项及缓解措施

1. **响应链断裂**
   - **风险**: 模块切换后菜单命令和快捷键失效
   - **缓解**: 实现完整的消息转发机制，充分测试响应链
   - **验证**: 每个checkpoint都包含响应链测试
   - **回退**: 保留原始setModule方法的备份

2. **状态同步问题**
   - **风险**: 模块切换时状态丢失或错乱
   - **缓解**: 实现严格的状态管理和生命周期控制
   - **验证**: 专门的状态持续性测试
   - **回退**: 提供状态重置功能

3. **内存泄漏**
   - **风险**: 共享容器或模块引用导致内存泄漏
   - **缓解**: 使用weak引用，实现正确的清理机制
   - **验证**: 使用Instruments进行内存分析
   - **监控**: 长时间运行测试

4. **XIB兼容性问题**
   - **风险**: XIB文件连接错误导致界面异常
   - **缓解**: 仔细检查XIB连接，多Xcode版本测试
   - **验证**: 界面显示和约束测试
   - **回退**: 保留XIB文件备份

## 开发建议 💡

### 开发顺序
1. **先实现核心逻辑** (Phase 1)，确保基础架构工作
2. **逐步清理代码** (Phase 2)，避免一次性大量修改
3. **优化和测试** (Phase 3-7)，确保稳定性

### 测试策略
1. **每个Phase完成后立即测试**，及时发现问题
2. **保持编译通过**，不积累编译错误
3. **增量验证**，每个功能点都要验证

### 代码管理
1. **频繁提交**，每个小功能完成就提交
2. **清晰的提交信息**，便于问题追踪
3. **保留备份**，关键文件修改前备份

---

**总计**: 约 70+ 个具体任务项  
**关键检查点**: 6 个主要验证节点  
**预估开发时间**: 3-4 周  
**核心风险**: 4 个主要风险点已识别并制定缓解措施