# Evernote Mac App UI 架构文档

## 概述

本文档详细描述了 Evernote Mac 客户端应用的整体 UI 架构，包括主要组件、布局结构和各部分之间的关系。

## 整体架构图

```
┌─────────────────────────────────────────────────────────────────────────────────────┐
│                    ENNoteCollectionWindowController (主窗口)                          │
├─────────────────────────────────────────────────────────────────────────────────────┤
│  Toolbar: [◀] [▶] [🔄] [👤] [💬] [🔍 Search Field] [⚙️] [📤]                      │
├─────────────────────────────────────────────────────────────────────────────────────┤
│ Banner Views (横幅通知区域) - ENBannerViewController                                 │
├─────────────────────────────────────────────────────────────────────────────────────┤
│                                                                                     │
│  ┌─────────────────────┬─────────────────────────────────────────────────────────┐  │
│  │   SideNavigation    │              Main Content Area                        │  │
│  │   (侧边栏)           │              (主内容区域)                              │  │
│  │                     │                                                       │  │
│  │ ENNavigation        │  ┌─────────────────────┬─────────────────────────────┐  │  │
│  │ OutlineView         │  │   Notes List Area   │   Editor Area             │  │  │
│  │ Controller          │  │   (笔记列表区域)     │   (编辑器区域)              │  │  │
│  │                     │  │                     │                           │  │  │
│  │ ├── 📓 All Notes    │  │ ┌─────────────────┐ │ ┌───────────────────────┐ │  │  │
│  │ ├── 📒 Notebooks    │  │ │ Header Container│ │ │                       │ │  │  │
│  │ │   ├─ Personal     │  │ │ (标题/搜索区域)  │ │ │   Note Title          │ │  │  │
│  │ │   ├─ Business     │ │  │ └─────────────────┘ │ │   ┌─────────────────┐ │ │  │  │
│  │ │   └─ Shared       │  │ ┌─────────────────┐ │ │   │                 │ │ │  │  │
│  │ ├── 🏷️  Tags        │  │ │ Assisted Search │ │ │   │   Editor View   │ │ │  │  │
│  │ ├── 🔗 Shortcuts    │  │ │ Container       │ │ │   │                 │ │ │  │  │
│  │ ├── ⏰ Recent Notes │  │ └─────────────────┘ │ │   │  (WebView)      │ │ │  │  │
│  │ ├── 👥 Team Spaces  │  │ ┌─────────────────┐ │ │   │                 │ │ │  │  │
│  │ ├── 🗂️  Workspaces  │  │ │ Privacy Lock    │ │ │   │                 │ │ │  │  │
│  │ ├── 🤖 AI Features  │  │ │ Tips Container  │ │ │   └─────────────────┘ │ │  │  │
│  │ ├── 💬 Messages     │  │ └─────────────────┘ │ │                       │ │  │  │
│  │ ├── 📚 Library      │  │ ┌─────────────────┐ │ │   Formatting Bar      │ │  │  │
│  │ └── 🗑️  Trash       │  │ │ Notes Container │ │ │   ┌─────────────────┐ │ │  │  │
│  │                     │  │ │                 │ │ │   │ [B] [I] [U] ... │ │ │  │  │
│  │                     │  │ │ ┌─────────────┐ │ │ │   └─────────────────┘ │ │  │  │
│  │                     │  │ │ │ Note Item 1 │ │ │ │                       │ │  │  │
│  │                     │  │ │ ├─────────────┤ │ │ │   Attachment Button   │ │  │  │
│  │                     │  │ │ │ Note Item 2 │ │ │ │   [📎] [📚]           │ │  │  │
│  │                     │  │ │ ├─────────────┤ │ │ │                       │ │  │  │
│  │                     │  │ │ │ Note Item 3 │ │ │ └───────────────────────┘ │  │  │
│  │                     │  │ │ ├─────────────┤ │ │                           │  │  │
│  │                     │  │ │ │     ...     │ │ │                           │  │  │
│  │                     │  │ │ └─────────────┘ │ │                           │  │  │
│  │                     │  │ │                 │ │                           │  │  │
│  │                     │  │ └─────────────────┘ │                           │  │  │
│  │                     │  └─────────────────────┴─────────────────────────────┘  │  │
│  └─────────────────────┴─────────────────────────────────────────────────────────┘  │
│                                                                                     │
└─────────────────────────────────────────────────────────────────────────────────────┘
```

## 核心架构层次

### 1. ENNoteCollectionWindowController - 主窗口控制器

**文件位置**: `Source/User-Interface/Note-Windows-Module/Note Collection Window/ENNoteCollectionWindowController.h/m`

**主要职责**:
- 整个应用的主窗口控制器，管理所有视图模块
- 管理窗口的整体布局和生命周期
- 协调各个 View Module 之间的交互
- 处理搜索、导航、工具栏等功能
- 管理横幅视图（Banner Views）

**关键属性**:
```objc
@property (nonnull, readonly) ENViewModulesManager *viewModulesManager;
@property (strong, nonatomic) ENNavigationOutlineViewController *outlineNavigationViewController;
@property (nonnull, readonly) ENNavigationController *navigationController;
@property (nullable, readonly) ENSearchContextController *searchContext;
```

### 2. 侧边栏（SideNavigation）结构

#### 2.1 导航大纲视图模块

**主控制器**: `ENNavigationOutlineViewController`
- **位置**: `SideNavigation/Navigation Outline View Module/ENNavigationOutlineViewController.h/m`
- **功能**: 管理左侧导航的大纲视图，包含笔记本、标签、团队空间等

**主要组件**:
```
SideNavigation/
├── Manager/
│   └── ENNavigationManager.h/m (导航管理器)
├── Navigation Outline View Module/
│   ├── ENNavigationOutlineViewController.h/m (主控制器)
│   ├── ENNavigationOutlineView.h/m (大纲视图)
│   ├── Items/ (各种导航项目)
│   │   ├── ENNavigationOutlineViewModuleItem
│   │   ├── ENNavigationOutlineViewActionItem  
│   │   └── ENNavigationOutlineViewGroupHeaderItem
│   └── Sources/ (数据源)
│       ├── ENNavigationOutlineNotebooksSource
│       ├── ENNavigationOutlineTagsSource
│       └── ENNavigationOutlineTeamSpacesSource
```

#### 2.2 导航栈视图模块  

**主控制器**: `ENNavigationStackViewController`
- **位置**: `SideNavigation/Navigation Stack View Module/`
- **功能**: 用于较小屏幕或窄模式下的导航界面

#### 2.3 侧边栏内容组织

```
侧边栏包含以下主要部分：
├── 📓 All Notes (所有笔记)
├── 📒 Notebooks (笔记本)
│   ├─ Personal (个人)
│   ├─ Business (商务)
│   └─ Shared (共享)
├── 🏷️ Tags (标签)
├── 🔗 Shortcuts (快捷方式)
├── ⏰ Recent Notes (最近笔记)
├── 👥 Team Spaces (团队空间)
├── 🗂️ Workspaces (工作区)
├── 🤖 AI Features (AI 功能)
├── 💬 Messages (消息)
├── 📚 Library (素材库)
└── 🗑️ Trash (废纸篓)
```

### 3. 主内容区域 - Notes Module

#### 3.1 EN4NotesModule - 笔记模块核心

**文件位置**: `View Modules/Notes Module/EN4NotesModule.h/m`

**主要功能**: 
- 管理笔记列表和编辑器的整体布局
- 处理不同视图模式的切换
- 管理搜索和过滤功能

**核心属性**:
```objc
@property (weak) IBOutlet NSView *contentContainerView;
@property (weak) IBOutlet ENSplitView *splitView;
@property (strong) ENNoteListContainerViewController *noteListContainerViewController;
@property (strong, readonly) NSViewController<ENNoteEditorViewControllerProtocol> *editorView;
@property (strong, readonly) EN4NoteArrayController *noteArrayController;
```

#### 3.2 布局结构 (基于 NotesView4.xib)

```
主分割视图 (ENSplitView)
├── 左侧：笔记列表区域 (noteListStackView - 292px 默认宽度)
│   ├── Header Container (pqF-d0-YTm) - 标题区域
│   ├── Assisted Search Container (0KN-Gp-b73) - 辅助搜索
│   ├── Privacy Lock Tips Container (KDY-CU-0ia) - 隐私锁提示
│   ├── CommEngine Card Container (d9C-mg-Ofo) - 通信引擎卡片
│   ├── Depth Search Container (IsN-9u-fmn) - 深度搜索
│   └── Notes Container (Lst-Cf-qmL) - 笔记列表容器
└── 右侧：编辑器区域 (contentContainerView - 可变宽度)
    └── ENNoteEditorViewController (笔记编辑器)
```

#### 3.3 笔记列表容器 (ENNoteListContainerViewController)

**文件位置**: `Notes Module/ENNoteListContainerViewController.h/m`

**支持的笔记列表视图模式**:
- **卡片视图** (Card View) - `EN4CardsViewController`
- **列表视图** (List View) - `EN4ListViewController`
- **摘要视图** (Snippet View) - `EN4SnippetsViewController`
- **顶部列表视图** (Top List View) - `EN4TopListViewController`

```objc
typedef NS_ENUM(NSUInteger, ENNotesModuleViewMode) {
  ENNotesModuleViewModeCard = 0,
  ENNotesModuleViewModeCardExpanded,
  ENNotesModuleViewModeSnippet,
  ENNotesModuleViewModeList,
  ENNotesModuleViewModeListTop
};
```

### 4. 编辑器区域

#### 4.1 ENNoteEditorViewController - 笔记编辑器

**文件位置**: `User-Interface/Note-Editor/ENNoteEditorViewController.h/m`

**核心组件**:
```objc
/// 编辑器 webView,可以是 ENMarkdownEditorWKWebView / ENMindmapEditorWKWebView / ENCommonEditorWKWebView(Uno)
@property (strong, readonly) NSView<ENEditorWebViewProtocol> *noteContentEditorView;
@property (strong, readonly) SuperNoteEditorToolbarViewController *toolbarViewController;
@property (weak) IBOutlet ENUnoEditorFormattingBar *formattingPaletteView;
@property (strong) ENNoteTitleViewController *titleViewController;
```

**支持的编辑器类型**:
- **ENMarkdownEditorWKWebView** - Markdown 编辑器
- **ENMindmapEditorWKWebView** - 思维导图编辑器  
- **ENCommonEditorWKWebView** - 富文本编辑器 (Uno)

**编辑器布局**:
```
ENNoteEditorViewController
├── Title View (标题区域)
│   └── ENNoteTitleViewController
├── Editor WebView (编辑器内容)
│   └── NSView<ENEditorWebViewProtocol>
├── Formatting Bar (格式化工具栏)
│   └── ENUnoEditorFormattingBar
├── Toolbar (工具栏)
│   └── SuperNoteEditorToolbarViewController
└── Attachment Controls (附件控制)
    ├── attachmentButton [📎]
    └── libraryButton [📚]
```

### 5. 模块化设计

#### 5.1 View Modules Manager

**ENViewModulesManager**: 管理所有视图模块的切换和生命周期

**支持的模块类型**:
```objc
├── EN4NotesModule (笔记模块) ← 默认主模块
├── EN4MessagesModule (消息模块)  
├── EN4BizLibraryModule (商业库模块)
├── ENSharedWithMeModule (与我共享模块)
├── EN4TagsModule (标签模块)
├── ENWorkspaceModule (工作区模块)
├── LightNoteViewModule (轻笔记模块)
├── LibraryViewModule (素材库模块)
├── NoteGraphViewModule (笔记图谱模块)
└── EverPenViewModule (EverPen 模块)
```

#### 5.2 模块切换机制

每个模块都继承自 `ENBaseViewModule`，实现统一的接口：
```objc
@interface ENBaseViewModule : NSObject
- (NSString *)moduleID;
- (NSString *)moduleName; 
- (NSView *)moduleView;
- (void)moduleWillAppear;
- (void)moduleDidAppear;
- (void)moduleWillDisappear;
- (void)moduleDidDisappear;
@end
```

## 核心组件分割结构

### 层次化分割视图

```
ENNoteCollectionWindowController (主窗口控制器)
└── ENSplitView (主分割视图)
    ├── 左侧面板 (292px 默认宽度)
    │   └── ENNavigationOutlineViewController (侧边栏)
    │       ├── ENNavigationOutlineView (大纲视图)
    │       └── 各种 NavigationOutlineViewItem
    └── 右侧面板 (可变宽度)
        └── ENViewModulesManager (视图模块管理器)
            └── EN4NotesModule (笔记模块 - 默认)
                └── ENSplitView (二级分割)
                    ├── Notes List Area (笔记列表区域)
                    │   └── ENNoteListContainerViewController
                    │       ├── Header Container
                    │       ├── Search Containers  
                    │       └── Notes Container
                    └── Editor Area (编辑器区域)
                        └── ENNoteEditorViewController
                            ├── Title View
                            ├── Editor WebView
                            ├── Formatting Bar
                            └── Attachment Controls
```

## 关键特性

### 1. **模块化架构**
- 每个功能区域都是独立的模块，便于维护和扩展
- 统一的模块接口，支持动态加载和切换
- 松耦合设计，模块间通过通知和代理通信

### 2. **分割视图布局**
- 使用 NSSpliView 实现可调整的多窗格布局
- 支持用户自定义界面比例
- 响应式设计，适应不同屏幕尺寸

### 3. **动态内容管理**
- 支持多种笔记列表视图模式
- 智能的内容容器管理
- 按需加载和卸载视图组件

### 4. **搜索集成**
- 深度集成的搜索功能贯穿整个 UI
- 多层级搜索容器支持不同搜索类型
- 实时搜索结果和建议

### 5. **协作功能**
- 内置消息、共享和团队协作功能
- 团队空间和工作区支持
- 实时协作状态显示

### 6. **AI 功能集成**
- 专门的 AI 功能模块和入口
- AI 助手和智能建议
- 与笔记编辑器深度集成

## 文件结构概览

```
Source/User-Interface/Note-Windows-Module/Note Collection Window/
├── ENNoteCollectionWindowController.h/m (主控制器)
├── ENNoteCollectionWindowController.xib (界面布局)
├── SideNavigation/ (侧边栏)
│   ├── Manager/ENNavigationManager.h/m
│   ├── Navigation Outline View Module/ (大纲视图模块)
│   └── Navigation Stack View Module/ (栈视图模块)
├── View Modules/ (视图模块)
│   ├── ENViewModulesManager.h/m (模块管理器)
│   ├── Notes Module/ (笔记模块)
│   │   ├── EN4NotesModule.h/m
│   │   ├── NotesView4.xib
│   │   └── ENNoteListContainerViewController.h/m
│   ├── Messages Module/ (消息模块)
│   ├── Business Library Module/ (商业库模块)
│   └── ... (其他模块)
├── Banner Views/ (横幅视图)
├── Toolbar/ (工具栏)
└── ToggleSidebarButton.swift (侧边栏切换)
```

## 总结

Evernote Mac 应用采用了高度模块化的架构设计，通过三层嵌套的分割视图结构实现了灵活的布局管理。主窗口控制器作为顶层协调者，管理侧边栏导航和可切换的功能模块，而笔记模块作为核心功能，进一步分割为笔记列表和编辑器两个主要区域。

这种架构设计的优势：
- **可维护性**: 模块化设计便于代码维护和功能扩展
- **用户体验**: 响应式布局适应不同使用场景
- **性能优化**: 按需加载减少内存占用
- **功能丰富**: 支持多种笔记类型和协作功能

该架构为 Evernote 提供了强大的基础，能够灵活应对复杂的笔记管理需求，同时保持良好的用户体验和代码质量。