# YX-182 番茄钟状态栏功能 - 实施清单

## 阶段一：基础框架搭建

### 1. 创建核心类文件
- [ ] 创建 `ENPomodoroStatusManager.h`
- [ ] 创建 `ENPomodoroStatusManager.m`  
- [ ] 创建 `ENPomodoroStatusView.h`
- [ ] 创建 `ENPomodoroStatusView.m`
- [ ] 在项目中正确添加文件引用

### 2. ENPomodoroStatusManager 基础实现
- [ ] 定义基本属性和枚举
  - [ ] `ENPomodoroManagerState` 枚举
  - [ ] `accountController` weak 引用
  - [ ] `statusItem` 属性
  - [ ] `customView` 属性
  - [ ] `updateTimer` 属性
- [ ] 实现初始化方法 `initWithAccountController:`
- [ ] 实现基础的 `showStatusItem` 方法
- [ ] 实现基础的 `hideStatusItem` 方法
- [ ] 实现 `dealloc` 清理方法

### 3. ENPomodoroStatusView 基础实现
- [ ] 定义基本属性
  - [ ] `remainingTime` 属性
  - [ ] `totalTime` 属性  
  - [ ] `isBreakTime` 属性
  - [ ] `isPaused` 属性
- [ ] 实现 `initWithFrame:` 方法
- [ ] 实现基础的 `drawRect:` 方法（先画一个简单圆形测试）
- [ ] 实现 `updateDisplay` 方法
- [ ] 实现鼠标事件处理 `mouseDown:` (用于右键菜单)

## 阶段二：集成到 ENAccountController

### 4. 修改 ENAccountController
- [ ] 在 `ENAccountController.h` 中添加属性声明
  - [ ] 添加 `@class ENPomodoroStatusManager;` 前向声明
  - [ ] 添加 `@property (strong, nonnull, readonly) ENPomodoroStatusManager *pomodoroStatusManager;`
- [ ] 在 `ENAccountController.m` 中实现集成
  - [ ] 在 `initWithAccountDecorator:` 中初始化 manager
  - [ ] 在 `tearDown` 中添加清理代码
  - [ ] 确保 `#import "ENPomodoroStatusManager.h"`

### 5. 连接 PomodoroViewController 通知
- [ ] 修改 `PomodoroViewController.swift` 的 `handleNotificationStateChange`
  - [ ] 添加获取 accountController 的代码
  - [ ] 调用 `pomodoroStatusManager.handleStateChangeNotification:`
  - [ ] 添加错误处理和日志记录

## 阶段三：实现核心功能

### 6. 实现状态变更处理
- [ ] 在 ENPomodoroStatusManager 中实现 `handleStateChangeNotification:`
  - [ ] 解析通知数据（startTime, type, duration, state）
  - [ ] 验证数据有效性
  - [ ] 调用相应的状态处理方法
- [ ] 实现状态转换逻辑
  - [ ] `startPomodoroWithInfo:` 方法
  - [ ] `pausePomodoro` 方法  
  - [ ] `resumePomodoro` 方法
  - [ ] `stopPomodoro` 方法

### 7. 实现倒计时逻辑
- [ ] 实现 Timer 管理
  - [ ] 创建定时器的方法
  - [ ] 停止定时器的方法
  - [ ] 定时器回调方法 `timerTick:`
- [ ] 实现时间计算
  - [ ] 基于 Unix 时间戳计算剩余时间
  - [ ] 处理暂停期间的时间偏移
  - [ ] 处理系统时间变更

### 8. 完善视觉绘制
- [ ] 实现完整的 `drawRect:` 方法
  - [ ] 绘制背景圆环
  - [ ] 绘制进度圆环（根据剩余时间计算角度）
  - [ ] 绘制时间文本（MM:SS 格式）
  - [ ] 适配不同状态的颜色（工作/休息）
- [ ] 实现颜色和样式
  - [ ] 工作状态：`NSColor.labelColor`
  - [ ] 休息状态：`NSColor.systemGreen`
  - [ ] 暂停状态：灰色或半透明
  - [ ] 适配暗色模式

## 阶段四：用户交互功能

### 9. 实现右键菜单
- [ ] 创建 `createContextMenu` 方法
  - [ ] 添加 "Open main window" 菜单项
  - [ ] 添加 "Exit Pomodoro" 菜单项
  - [ ] 设置正确的 target 和 action
- [ ] 实现菜单响应方法
  - [ ] `openMainWindow:` - 调用主窗口的 showPomodoro
  - [ ] `exitPomodoro:` - 隐藏状态栏并清理状态
- [ ] 在 ENPomodoroStatusView 中处理右键点击
  - [ ] 重写 `rightMouseDown:` 方法
  - [ ] 显示上下文菜单

### 10. 实现完成通知
- [ ] 创建完成通知弹窗
  - [ ] 设计简单的弹窗视图控制器
  - [ ] 实现 "You've finished 1 Pomodoro. Take a break." 消息
  - [ ] 支持不同类型完成消息（工作完成/休息完成）
- [ ] 在倒计时结束时显示通知
  - [ ] 检测倒计时归零
  - [ ] 显示 NSPopover 或 NSAlert
  - [ ] 自动消失逻辑

## 阶段五：国际化和优化

### 11. 国际化支持
- [ ] 添加本地化字符串
  - [ ] "Open main window" / "打开主窗口"
  - [ ] "Exit Pomodoro" / "退出番茄钟"  
  - [ ] "You've finished 1 Pomodoro. Take a break." / "您已完成1个番茄钟，请休息一下。"
- [ ] 在代码中使用 `NSLocalizedString`
- [ ] 测试中英文切换

### 12. 错误处理和边界情况
- [ ] 处理无效数据
  - [ ] startTime 为空或无效
  - [ ] duration 为负数或过大
  - [ ] type 或 state 字符串错误
- [ ] 处理系统事件
  - [ ] 系统休眠和唤醒
  - [ ] 时区变更
  - [ ] 网络连接状态变化
- [ ] 内存管理
  - [ ] 检查循环引用
  - [ ] 确保 Timer 正确释放
  - [ ] 验证 weak 引用的正确性

## 阶段六：测试和调试

### 13. 功能测试
- [ ] 基础显示测试
  - [ ] 状态栏图标正常显示
  - [ ] 圆环绘制正确
  - [ ] 时间格式正确 (MM:SS)
- [ ] 状态变更测试
  - [ ] 开始番茄钟 → 显示黑色圆环
  - [ ] 开始休息 → 显示绿色圆环
  - [ ] 暂停 → 停止倒计时，界面变灰
  - [ ] 恢复 → 继续倒计时，恢复颜色
  - [ ] 停止 → 隐藏状态栏
- [ ] 交互测试
  - [ ] 右键菜单显示正确
  - [ ] "打开主窗口" 能正确调用 showPomodoro
  - [ ] "退出番茄钟" 能正确清理状态
  - [ ] 完成通知能正常显示

### 14. 边界情况测试
- [ ] 网页关闭后状态栏行为
- [ ] 多账户切换时的表现
- [ ] 系统重启后的状态恢复
- [ ] 长时间运行的内存稳定性

### 15. 性能优化
- [ ] CPU 使用率检查
  - [ ] Timer 频率优化（建议1秒更新一次）
  - [ ] 绘制效率优化（避免不必要的重绘）
- [ ] 内存使用检查
  - [ ] 无内存泄漏
  - [ ] 合理的内存占用
- [ ] 电池影响评估
  - [ ] 后台 CPU 使用最小化
  - [ ] 合理的刷新频率

## 完成标准

### 验收条件
- [ ] 功能完整：所有需求功能均正常工作
- [ ] 界面美观：符合 macOS 设计规范
- [ ] 性能良好：CPU 和内存使用合理
- [ ] 稳定可靠：无崩溃，无内存泄漏
- [ ] 国际化完整：中英文显示正常
- [ ] 代码质量：遵循项目编码规范，注释完整

### 最终检查清单
- [ ] 代码审查通过
- [ ] 单元测试通过
- [ ] 手动测试通过  
- [ ] 性能测试通过
- [ ] 内存泄漏检查通过
- [ ] 多语言测试通过
- [ ] 文档更新完成

---

**预计总工作量：** 3-4个工作日
**关键里程碑：** 
1. 基础框架完成（1天）
2. 核心功能完成（1.5天）
3. 用户交互完成（1天）
4. 测试和优化完成（0.5天）