# YX-182 番茄钟状态栏功能 - 文件结构

## 新增文件清单

### 1. 核心管理类
```
Source/Application/Pomodoro-Status/
├── ENPomodoroStatusManager.h
├── ENPomodoroStatusManager.m
├── ENPomodoroStatusView.h
└── ENPomodoroStatusView.m
```

### 2. 支持类（可选）
```
Source/Application/Pomodoro-Status/
├── ENPomodoroCompletionViewController.h    // 完成通知弹窗
├── ENPomodoroCompletionViewController.m
├── ENPomodoroCompletionView.xib            // 弹窗界面（可选）
└── ENPomodoroConstants.h                   // 常量定义
```

## 修改现有文件

### 1. ENAccountController 集成
```
Source/Application/Account-Controller/
├── ENAccountController.h                   // 添加属性声明
└── ENAccountController.m                   // 添加初始化和清理代码
```

### 2. PomodoroViewController 通知
```
Source/User-Interface/Task/
└── PomodoroViewController.swift            // 修改 handleNotificationStateChange
```

### 3. 项目配置文件  
```
EverNote.xcodeproj/
└── project.pbxproj                         // 添加新文件引用和编译设置
```

## 详细文件说明

### ENPomodoroStatusManager.h
```objc
//
//  ENPomodoroStatusManager.h
//  Evernote
//
//  Created by [Your Name] on [Date].
//  Copyright © [Year] Evernote Corporation. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class ENAccountController;
@class ENPomodoroStatusView;

// 番茄钟状态枚举
typedef NS_ENUM(NSInteger, ENPomodoroManagerState) {
    ENPomodoroManagerStateIdle,      // 空闲状态
    ENPomodoroManagerStateActive,    // 活跃运行
    ENPomodoroManagerStatePaused,    // 暂停状态
};

// 番茄钟类型枚举
typedef NS_ENUM(NSInteger, ENPomodoroType) {
    ENPomodoroTypeWork,              // 工作状态
    ENPomodoroTypeBreak,             // 休息状态
};

// 番茄钟操作状态枚举
typedef NS_ENUM(NSInteger, ENPomodoroActionState) {
    ENPomodoroActionStateStarted,    // 开始
    ENPomodoroActionStatePaused,     // 暂停
    ENPomodoroActionStateStopped,    // 停止
    ENPomodoroActionStateResumed,    // 恢复
};

/**
 * 番茄钟状态栏管理器
 * 负责管理状态栏显示、倒计时逻辑和用户交互
 */
@interface ENPomodoroStatusManager : NSObject

// 关联的账户控制器
@property (weak, nonnull) ENAccountController *accountController;

// 当前状态
@property (readonly) ENPomodoroManagerState state;
@property (readonly) BOOL isActive;

// 指定初始化方法
- (nonnull instancetype)initWithAccountController:(nonnull ENAccountController *)accountController NS_DESIGNATED_INITIALIZER;

// 状态栏控制
- (void)showStatusItem;
- (void)hideStatusItem;

// 番茄钟状态处理 - 主要接口
- (void)handleStateChangeNotification:(nonnull NSDictionary *)info;

// 不允许直接初始化
- (nonnull instancetype)init NS_UNAVAILABLE;

@end
```

### ENPomodoroStatusView.h
```objc
//
//  ENPomodoroStatusView.h
//  Evernote
//
//  Created by [Your Name] on [Date].
//  Copyright © [Year] Evernote Corporation. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class ENPomodoroStatusManager;

/**
 * 番茄钟状态栏自定义视图
 * 负责绘制圆环进度条和时间显示
 */
@interface ENPomodoroStatusView : NSView

// 关联的管理器
@property (weak, nullable) ENPomodoroStatusManager *manager;

// 时间相关属性
@property (assign) NSTimeInterval remainingTime;    // 剩余时间（秒）
@property (assign) NSTimeInterval totalTime;       // 总时间（秒）

// 状态属性
@property (assign) BOOL isBreakTime;               // 是否为休息时间
@property (assign) BOOL isPaused;                  // 是否为暂停状态

// 更新显示
- (void)updateDisplay;

// 格式化时间显示
+ (nonnull NSString *)formatTime:(NSTimeInterval)timeInterval;

@end
```

## 实现要点

### 1. 目录结构建议
建议在 `Source/Application/` 下新建 `Pomodoro-Status` 目录，保持与其他功能模块的组织一致性。

### 2. 依赖关系
- ENPomodoroStatusManager 依赖 ENAccountController（weak 引用）
- ENPomodoroStatusView 依赖 ENPomodoroStatusManager（weak 引用）  
- ENAccountController 持有 ENPomodoroStatusManager（strong 引用）

### 3. 内存管理
- 使用 weak 引用避免循环引用
- 在 dealloc 中正确清理 NSTimer 和通知监听
- 确保状态栏项的正确释放

### 4. 线程安全
- UI 更新确保在主线程执行
- 时间计算可在后台线程进行
- 使用适当的同步机制保护共享数据

### 5. 错误处理
- 验证通知数据的完整性
- 处理异常的时间值
- 提供降级方案

这个文件结构设计确保了：
- 模块化和可维护性
- 与现有代码架构的一致性  
- 清晰的依赖关系
- 便于测试和调试