# 番茄钟状态栏测试面板使用指南

## 🎯 测试面板功能

我已经在 PomodoroViewController 中集成了一个测试面板，可以完整测试 ENPomodoroStatusManager 的所有状态管理功能。

### 📍 面板位置
- 测试面板覆盖在 PomodoroViewController 的 WebView 之上
- 右上角有一个 "Show Test Panel" 按钮用于显示/隐藏测试界面

## 🔧 测试界面组件

### 1. 时长选择器
```
Duration: [25 minutes ▼]
```
- **25 minutes**: 标准番茄钟时长
- **15 minutes**: 短番茄钟时长  
- **5 minutes**: 休息时长
- **1 minute (test)**: 快速测试用

### 2. 功能按钮组

#### 启动按钮
- **Start Work (25min)** - 蓝色按钮
  - 发送: `{state: "started", type: "work", duration: 选中时长}`
  - 测试: 工作状态的黑色圆环显示

- **Start Break (5min)** - 绿色按钮  
  - 发送: `{state: "started", type: "break", duration: 选中时长}`
  - 测试: 休息状态的绿色圆环显示

#### 控制按钮
- **Pause** - 橙色按钮
  - 发送: `{state: "paused", type: 当前类型}`
  - 测试: 暂停状态的橙色圆环显示

- **Resume** - 绿色按钮
  - 发送: `{state: "resumed", type: 当前类型}`  
  - 测试: 恢复到之前的颜色状态

- **Stop** - 红色按钮
  - 发送: `{state: "stopped", type: 当前类型}`
  - 测试: 状态栏隐藏功能

### 3. 状态显示
```
Status: Working    Time: 25:00
```
- **Status**: 显示当前测试状态 (Working/Break/Paused/Stopped)
- **Time**: 显示选中的时长 (MM:SS 格式)

## 🧪 测试步骤建议

### 基础功能测试
1. **启动工作模式**
   - 点击 "Start Work (25min)"
   - ✅ 检查状态栏是否出现黑色圆环 + 25:00
   - ✅ 检查倒计时是否正常运行

2. **启动休息模式**  
   - 点击 "Start Break (5min)"
   - ✅ 检查状态栏圆环是否变为绿色 + 05:00
   - ✅ 检查倒计时是否重新开始

3. **暂停功能**
   - 在运行状态下点击 "Pause" 
   - ✅ 检查圆环是否变为橙色
   - ✅ 检查倒计时是否停止

4. **恢复功能**
   - 在暂停状态下点击 "Resume"
   - ✅ 检查圆环颜色是否恢复 (工作=黑色/休息=绿色)
   - ✅ 检查倒计时是否继续

5. **停止功能**
   - 点击 "Stop"
   - ✅ 检查状态栏是否完全消失

### 右键菜单测试
1. **右键测试**
   - 在状态栏图标上右键点击
   - ✅ 检查是否弹出菜单: "Open main window" / "Exit Pomodoro"

2. **左键测试**
   - 左键点击状态栏图标
   - ✅ 检查是否触发暂停/恢复功能

### 快速测试
1. **1分钟测试**
   - 选择 "1 minute (test)" 时长
   - 启动工作或休息模式
   - ✅ 等待1分钟检查完成通知是否弹出

## 📝 测试记录模板

```
测试日期: ___________
测试人员: ___________

[ ] 工作模式启动 - 黑色圆环显示正常
[ ] 休息模式启动 - 绿色圆环显示正常  
[ ] 暂停功能 - 橙色圆环显示正常
[ ] 恢复功能 - 颜色恢复正常
[ ] 停止功能 - 状态栏隐藏正常
[ ] 右键菜单 - 菜单显示正常
[ ] 左键暂停 - 功能响应正常
[ ] 倒计时精度 - 时间显示准确
[ ] 完成通知 - 通知弹出正常
[ ] 内存泄漏 - 长时间运行稳定

问题记录:
________________
________________
________________
```

## 🔍 调试信息

测试面板会在控制台输出详细日志，前缀为 `[PomodoroTest]`:

```
[PomodoroTest] Started work session: 1500s
[PomodoroTest] Sent notification: {state=started, type=work, duration=1500, startTime=1640995200}
[PomodoroTest] Duration changed to: 300s
[PomodoroTest] Paused session
```

ENPomodoroStatusManager 的日志前缀为 `[PomodoroStatus]`:

```
[PomodoroStatus] Handling state change: {state=started, type=work, duration=1500, startTime=1640995200}
[PomodoroStatus] Starting pomodoro - Type: work
[PomodoroStatus] Status item created
[PomodoroStatus] Update timer started
```

## 💡 使用技巧

1. **快速测试**: 使用1分钟时长进行快速功能验证
2. **状态切换**: 可以在不同状态间快速切换测试各种边界情况
3. **日志查看**: 观察控制台日志了解内部状态变化
4. **面板控制**: 使用 "Hide Panel" 按钮临时隐藏测试界面

这个测试面板提供了完整的 ENPomodoroStatusManager 功能测试能力，无需依赖网页端即可验证所有状态管理逻辑。