# Evernote Mac Shortcuts UI 重新设计实现方案

## 项目概述

本文档详细描述了Evernote Mac应用中Shortcuts展现UI的重新设计实现方案。目标是将Shortcuts从当前的popover弹窗形式改为与Notebooks、Tags类似的overlay覆盖层形式。

## 需求背景

### 当前状态
- Shortcuts目前使用popover弹窗显示
- 用户体验不够一致，与其他overlay模块（如notebooks、tags）存在差异
- 需要统一UI交互模式，提供更好的用户体验

### 目标状态
- Shortcuts使用与notebooks、tags相同的overlay模式
- 支持多种shortcuts类型的层级显示
- 提供拖拽排序功能
- 保持现有的所有功能特性

## 技术架构设计

### 1. 核心组件架构

```
ShortcutsContainerViewController (Swift)
├── ShortcutsHeaderViewController (Swift)
└── ShortcutsListViewController (Swift)
    ├── ShortcutsListDataSource
    ├── ShortcutsListCellView
    └── ShortcutsListRowView
```

### 2. 数据类型支持

| 数据类型 | 图标 | 层级支持 | 特殊功能 |
|---------|------|---------|----------|
| ENNoteMO | shortcuts-note | 无 | 直接打开笔记 |
| ENNotebookMO | shortcuts-notebook | 无 | 显示笔记本内容 |
| ENSavedSearchMO | shortcuts-savesearched | 无 | 执行保存的搜索 |
| ENUniqueTag | shortcuts-tag | 无限层级 | 支持展开/收起 |
| ENStackShortcut | shortcuts-notebookStack | 一级展开 | 显示笔记本列表 |

### 3. 系统集成点

#### 3.1 ENOverlayManager 扩展
- 添加 `ENOverlayTypeShortcuts` 枚举值
- 实现 shortcuts overlay 的显示/隐藏逻辑
- 管理shortcuts容器的约束和生命周期

#### 3.2 ENNoteCollectionWindowController 扩展
- 添加 `shortcutsViewController` 属性（懒加载）
- 实现 shortcuts overlay 的公共API
- 集成到现有的窗口管理系统

#### 3.3 导航控制器修改
- 修改 `ENNavigationOutlineViewController` 中的shortcuts action
- 修改 `ENNavigationNarrowViewController` 中的shortcuts action
- 将 `showShortcutsPopover` 改为 `toggleShortcutsOverlay`

## 详细设计规范

### 1. UI设计规范

#### 布局规范
- **容器宽度**: 294px（与notebook、tags保持一致）
- **位置**: 左侧对齐，覆盖整个模块视图区域
- **背景**: 半透明黑色遮罩（alpha: 0.6）

#### Header设计
- **标题**: "Shortcuts"（NSLocalizedString）
- **功能**: 仅显示标题，无搜索框、排序按钮等
- **样式**: 与NotebookListHeaderViewController保持一致的视觉风格

#### 列表设计
- **行高**: 动态高度，支持层级缩进
- **图标**: 16x16px，根据数据类型显示对应图标
- **文本**: 显示shortcuts名称
- **Hover效果**: 与NotebookListRowView相同的hover动效
- **层级指示**: 支持展开/收起箭头（针对ENUniqueTag和ENStackShortcut）

### 2. 交互设计规范

#### 点击行为
- **ENNoteMO**: 调用 `showObject:` 打开对应笔记
- **ENNotebookMO**: 调用 `showObject:` 显示笔记本中的笔记
- **ENSavedSearchMO**: 调用 `showObject:` 执行保存的搜索
- **ENUniqueTag**: 调用 `showObject:` 显示标签相关的笔记
- **ENStackShortcut**: 展开/收起或调用 `showObject:` 显示stack中的笔记

#### 拖拽行为
- **支持**: shortcuts项目的拖拽重新排序
- **约束**: 保持层级结构的完整性
- **反馈**: 提供拖拽时的视觉反馈

#### 层级展开
- **ENUniqueTag**: 支持无限层级展开，类似TagsModule
- **ENStackShortcut**: 支持一级展开显示笔记本列表

### 3. 数据源设计

#### ShortcutsListDataSource
```swift
class ShortcutsListDataSource: NSObject, NSOutlineViewDataSource {
    - func outlineView(_:numberOfChildrenOfItem:) -> Int
    - func outlineView(_:child:ofItem:) -> Any
    - func outlineView(_:isItemExpandable:) -> Bool
    // 拖拽支持
    - func outlineView(_:writeItems:toPasteboard:) -> Bool
    - func outlineView(_:validateDrop:proposedItem:proposedChildIndex:) -> NSDragOperation
    - func outlineView(_:acceptDrop:item:childIndex:) -> Bool
}
```

#### 数据模型
- 基于 `ENShortcutsController.arrangedObjects`
- 支持层级结构的数据转换
- 实现拖拽排序的数据更新

## 实施计划

### 第一阶段：基础架构（1-2天）
1. **ENOverlayManager扩展**
   - 添加 `ENOverlayTypeShortcuts` 枚举
   - 实现 `showShortcutsOverlay` 和 `hideShortcutsOverlay`
   - 添加相关属性和约束管理

2. **ENNoteCollectionWindowController扩展**
   - 添加 `shortcutsViewController` 懒加载属性
   - 实现 overlay 管理方法
   - 集成到现有的 overlay 系统

### 第二阶段：Swift组件开发（3-4天）
3. **ShortcutsContainerViewController**
   - 主容器控制器实现
   - 参考NotebookListContainerViewController架构
   - 管理header和list的布局

4. **ShortcutsHeaderViewController**
   - 简化的header实现
   - 仅包含标题显示
   - 与现有样式保持一致

5. **ShortcutsListViewController**
   - 列表控制器实现
   - 集成ENShortcutsController数据源
   - 处理用户交互事件

### 第三阶段：UI组件开发（2-3天）
6. **ShortcutsListCellView和RowView**
   - 单元格视图实现
   - 支持不同类型的shortcuts显示
   - 实现hover效果和层级指示

7. **数据源和委托**
   - ShortcutsListDataSource实现
   - 支持层级数据处理
   - 拖拽排序功能

### 第四阶段：系统集成（1-2天）
8. **导航控制器修改**
   - 修改ENNavigationOutlineViewController
   - 修改ENNavigationNarrowViewController
   - 更新action方法

### 第五阶段：测试验证（1-2天）
9. **功能测试**
   - 所有shortcuts类型显示测试
   - 层级展开收起测试
   - 拖拽排序测试
   - 性能和内存测试

## 技术风险与应对

### 风险点
1. **数据源复杂性**: ENShortcutsController数据类型多样，层级处理复杂
2. **拖拽实现**: 需要保持层级结构完整性
3. **性能考虑**: 大量shortcuts时的渲染性能
4. **兼容性**: 与现有overlay系统的兼容性

### 应对措施
1. **分步实现**: 先实现基础显示，再添加高级功能
2. **参考现有**: 大量参考NotebookModule和TagsModule的实现
3. **性能优化**: 使用视图重用和延迟加载
4. **充分测试**: 多种数据场景的测试验证

## 验收标准

### 功能验收
- [ ] Shortcuts overlay正确显示所有类型的shortcuts
- [ ] 支持ENUniqueTag的无限层级展开收起
- [ ] 支持ENStackShortcut的笔记本列表展开
- [ ] 支持拖拽重新排序功能
- [ ] 点击不同类型shortcuts能正确调用showObject:

### 性能验收
- [ ] overlay显示/隐藏响应时间 < 200ms
- [ ] 大量shortcuts（>100个）时渲染流畅
- [ ] 内存使用合理，无内存泄露

### UI验收
- [ ] 与notebooks、tags overlay视觉风格一致
- [ ] hover效果流畅自然
- [ ] 层级指示清晰明确
- [ ] 拖拽反馈直观有效

## 后续扩展

### 可能的功能扩展
1. **搜索功能**: 在header中添加搜索框
2. **排序功能**: 支持按名称、类型、使用频率排序
3. **右键菜单**: 为不同类型提供上下文菜单
4. **键盘导航**: 支持键盘快捷键操作

### 技术债务
1. **代码重构**: 抽象出公共的overlay组件基类
2. **测试覆盖**: 增加单元测试和集成测试
3. **文档完善**: 补充技术文档和使用说明

---

**文档版本**: 1.0  
**创建时间**: 2025-12-02  
**最后更新**: 2025-12-02  
**负责人**: Claude Code