# Shortcuts UI 重新设计开发任务清单

## 第一阶段：基础架构修改

### 1. ENOverlayManager 扩展
- [ ] **1.1** 在 `ENOverlayType` 枚举中添加 `ENOverlayTypeShortcuts`
- [ ] **1.2** 添加 `shortcutsContainer` 属性 (BlockContainerView *)
- [ ] **1.3** 添加 `shortcutsContainerConstraints` 约束缓存属性 (NSArray *)
- [ ] **1.4** 在 `isShortcutsOverlayVisible` getter 中实现shortcuts overlay可见性检查
- [ ] **1.5** 在 `showOverlay:` 方法中添加 `ENOverlayTypeShortcuts` case
- [ ] **1.6** 在 `hideOverlay:` 方法中添加 `ENOverlayTypeShortcuts` case
- [ ] **1.7** 在 `isOverlayVisible:` 方法中添加 `ENOverlayTypeShortcuts` case
- [ ] **1.8** 实现 `showShortcutsOverlay` 私有方法
- [ ] **1.9** 实现 `hideShortcutsOverlay` 私有方法
- [ ] **1.10** 更新 `hideOtherOverlaysExcept:` 方法包含shortcuts处理
- [ ] **1.11** 更新 `hideAllOverlays` 方法包含shortcuts处理

**文件位置**: 
- `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/ENOverlayManager.h`
- `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/ENOverlayManager.m`

### 2. ENNoteCollectionWindowController 扩展
- [ ] **2.1** 在header中声明 `shortcutsViewController` 属性
- [ ] **2.2** 在实现中添加 `shortcutsViewController` 懒加载getter
- [ ] **2.3** 添加 `showShortcutsOverlay` 公共方法
- [ ] **2.4** 添加 `hideShortcutsOverlay` 公共方法  
- [ ] **2.5** 添加 `toggleShortcutsOverlay` 公共方法
- [ ] **2.6** 添加 `isShortcutsOverlayVisible` getter方法
- [ ] **2.7** 在 `showTagAndNotebookViewIfNeeded` 方法中添加shortcuts初始化
- [ ] **2.8** 确保shortcuts相关对象在tearDown时正确清理

**文件位置**:
- `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/ENNoteCollectionWindowController.h`
- `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/ENNoteCollectionWindowController.m`

## 第二阶段：Swift组件创建

### 3. 创建Shortcuts Module新目录
- [ ] **3.1** 创建目录 `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/`
- [ ] **3.2** 创建子目录 `Header/`
- [ ] **3.3** 创建子目录 `List/`
- [ ] **3.4** 创建子目录 `Data/`

### 4. ShortcutsContainerViewController 实现
- [ ] **4.1** 创建 `ShortcutsContainerViewController.swift` 文件
- [ ] **4.2** 定义类基础结构，继承自NSViewController
- [ ] **4.3** 添加accountController和collectionWindowController属性
- [ ] **4.4** 实现init方法
- [ ] **4.5** 创建headerVC和listVC懒加载属性
- [ ] **4.6** 实现loadView方法，设置MouseInterceptingView
- [ ] **4.7** 实现setupUI方法，配置header和list布局
- [ ] **4.8** 添加@objc标记以供Objective-C调用
- [ ] **4.9** 实现deinit清理方法

**文件位置**: `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/ShortcutsContainerViewController.swift`

### 5. ShortcutsHeaderViewController 实现
- [ ] **5.1** 创建 `Header/ShortcutsHeaderViewController.swift` 文件
- [ ] **5.2** 定义类基础结构，继承自NSViewController
- [ ] **5.3** 添加titleLabel属性
- [ ] **5.4** 实现loadView方法
- [ ] **5.5** 配置titleLabel文本为NSLocalizedString("Shortcuts")
- [ ] **5.6** 设置header布局约束
- [ ] **5.7** 应用主题样式
- [ ] **5.8** 确保高度约束与其他module保持一致

**文件位置**: `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/Header/ShortcutsHeaderViewController.swift`

### 6. ShortcutsListViewController 实现
- [ ] **6.1** 创建 `List/ShortcutsListViewController.swift` 文件
- [ ] **6.2** 定义类基础结构，继承自NSViewController
- [ ] **6.3** 添加accountController和collectionWindowController属性
- [ ] **6.4** 创建NSOutlineView属性
- [ ] **6.5** 创建ScrollView容器
- [ ] **6.6** 实现loadView和viewDidLoad方法
- [ ] **6.7** 配置outline view的基本设置
- [ ] **6.8** 设置dataSource和delegate
- [ ] **6.9** 注册cell类型
- [ ] **6.10** 实现数据刷新方法

**文件位置**: `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/List/ShortcutsListViewController.swift`

## 第三阶段：数据源和UI组件

### 7. ShortcutsListDataSource 实现
- [ ] **7.1** 创建 `List/ShortcutsListDataSource.swift` 文件
- [ ] **7.2** 实现NSOutlineViewDataSource协议
- [ ] **7.3** 添加accountController属性获取shortcuts数据
- [ ] **7.4** 实现 `outlineView(_:numberOfChildrenOfItem:)` 方法
- [ ] **7.5** 实现 `outlineView(_:child:ofItem:)` 方法
- [ ] **7.6** 实现 `outlineView(_:isItemExpandable:)` 方法
- [ ] **7.7** 处理ENUniqueTag的层级结构
- [ ] **7.8** 处理ENStackShortcut的笔记本列表
- [ ] **7.9** 实现拖拽相关方法
  - [ ] **7.9.1** `outlineView(_:writeItems:toPasteboard:)`
  - [ ] **7.9.2** `outlineView(_:validateDrop:proposedItem:proposedChildIndex:)`
  - [ ] **7.9.3** `outlineView(_:acceptDrop:item:childIndex:)`
- [ ] **7.10** 实现数据变更通知处理

**文件位置**: `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/List/ShortcutsListDataSource.swift`

### 8. ShortcutsListDelegate 实现
- [ ] **8.1** 创建 `List/ShortcutsListDelegate.swift` 文件
- [ ] **8.2** 实现NSOutlineViewDelegate协议
- [ ] **8.3** 实现 `outlineView(_:viewFor:item:)` 方法
- [ ] **8.4** 处理不同shortcuts类型的cell创建
- [ ] **8.5** 实现 `outlineView(_:heightOfRowByItem:)` 方法
- [ ] **8.6** 实现点击选择处理
- [ ] **8.7** 实现展开/收起状态管理
- [ ] **8.8** 处理用户交互事件

**文件位置**: `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/List/ShortcutsListDelegate.swift`

### 9. ShortcutsListCellView 实现
- [ ] **9.1** 创建 `List/ShortcutsListCellView.swift` 文件
- [ ] **9.2** 继承自NSTableCellView
- [ ] **9.3** 添加iconImageView属性
- [ ] **9.4** 添加nameLabel属性
- [ ] **9.5** 添加moreButton属性（可选）
- [ ] **9.6** 添加expandButton属性（层级项目）
- [ ] **9.7** 实现setupUI方法配置布局
- [ ] **9.8** 实现configureWithItem方法设置内容
- [ ] **9.9** 处理不同shortcuts类型的图标映射
- [ ] **9.10** 应用主题样式

**文件位置**: `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/List/ShortcutsListCellView.swift`

### 10. ShortcutsListRowView 实现
- [ ] **10.1** 创建 `List/ShortcutsListRowView.swift` 文件
- [ ] **10.2** 继承自NSTableRowView
- [ ] **10.3** 实现hover效果（参考NotebookListRowView）
- [ ] **10.4** 添加selection状态处理
- [ ] **10.5** 实现drawRect方法自定义绘制
- [ ] **10.6** 处理层级缩进显示
- [ ] **10.7** 支持拖拽视觉反馈
- [ ] **10.8** 应用主题样式

**文件位置**: `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/List/ShortcutsListRowView.swift`

## 第四阶段：系统集成

### 11. 导航控制器修改
- [ ] **11.1** 修改ENNavigationOutlineViewController.m中的shortcuts action
  - [ ] **11.1.1** 找到showShortcutsPopover:方法
  - [ ] **11.1.2** 替换为toggleShortcutsOverlay:方法调用
  - [ ] **11.1.3** 更新相关的action绑定
- [ ] **11.2** 修改ENNavigationNarrowViewController.m中的shortcuts action
  - [ ] **11.2.1** 找到showShortcutsPopover相关代码
  - [ ] **11.2.2** 替换为toggleShortcutsOverlay调用
  - [ ] **11.2.3** 更新shortcutsActionItem的action设置

**文件位置**: 
- `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/SideNavigation/Navigation Outline View Module/ENNavigationOutlineViewController.m`
- `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/SideNavigation/Navigation Stack View Module/ENNavigationNarrowViewController.m`

### 12. 数据层集成
- [ ] **12.1** 创建 `Data/ShortcutsDataHelper.swift` 文件
- [ ] **12.2** 实现ENShortcutsController数据的Swift包装
- [ ] **12.3** 处理数据变更通知
- [ ] **12.4** 实现层级数据转换逻辑
- [ ] **12.5** 处理拖拽排序的数据更新
- [ ] **12.6** 添加数据验证和错误处理

**文件位置**: `/Users/wright/YXCode/maccopy/Source/User-Interface/Note-Windows-Module/Note Collection Window/View Modules/Shortcuts Module New/Data/ShortcutsDataHelper.swift`

## 第五阶段：测试验证

### 13. 基础功能测试
- [ ] **13.1** 验证shortcuts overlay能正常显示和隐藏
- [ ] **13.2** 测试所有ENNoteMO类型shortcuts的显示
- [ ] **13.3** 测试所有ENNotebookMO类型shortcuts的显示
- [ ] **13.4** 测试所有ENSavedSearchMO类型shortcuts的显示
- [ ] **13.5** 测试所有ENUniqueTag类型shortcuts的显示
- [ ] **13.6** 测试所有ENStackShortcut类型shortcuts的显示
- [ ] **13.7** 验证图标映射正确性
- [ ] **13.8** 测试点击行为调用showObject:

### 14. 层级功能测试
- [ ] **14.1** 测试ENUniqueTag的展开/收起功能
- [ ] **14.2** 验证ENUniqueTag的多级层级显示
- [ ] **14.3** 测试ENStackShortcut的笔记本列表展开
- [ ] **14.4** 验证层级缩进显示正确
- [ ] **14.5** 测试层级状态保持
- [ ] **14.6** 验证层级数据更新

### 15. 交互功能测试
- [ ] **15.1** 测试拖拽排序基础功能
- [ ] **15.2** 验证拖拽时的视觉反馈
- [ ] **15.3** 测试层级项目的拖拽约束
- [ ] **15.4** 验证拖拽后数据保存
- [ ] **15.5** 测试hover效果
- [ ] **15.6** 验证keyboard navigation（如果实现）

### 16. 集成测试
- [ ] **16.1** 测试与其他overlay的互斥性
- [ ] **16.2** 验证窗口关闭时的cleanup
- [ ] **16.3** 测试模块切换时的状态保持
- [ ] **16.4** 验证内存使用和泄露
- [ ] **16.5** 测试性能（大量shortcuts）
- [ ] **16.6** 验证主题切换适配

### 17. 边界情况测试
- [ ] **17.1** 测试空shortcuts列表
- [ ] **17.2** 测试单一类型shortcuts
- [ ] **17.3** 测试大量shortcuts（性能）
- [ ] **17.4** 测试深层级ENUniqueTag
- [ ] **17.5** 测试异常数据处理
- [ ] **17.6** 验证错误恢复机制

## 完成标准

### 功能完整性
- ✅ 所有shortcuts类型正确显示
- ✅ 层级展开收起功能正常
- ✅ 拖拽排序功能正常  
- ✅ 点击交互行为正确
- ✅ 与现有系统集成无冲突

### 性能标准
- ✅ Overlay显示响应时间 < 200ms
- ✅ 大量shortcuts时渲染流畅
- ✅ 内存使用合理，无泄露
- ✅ CPU使用率正常

### 代码质量
- ✅ 代码结构清晰，遵循现有架构
- ✅ 注释充分，文档完整
- ✅ 错误处理完善
- ✅ 符合项目编码规范

---

**任务总数**: 99项  
**预估工期**: 8-10个工作日  
**关键里程碑**: 
1. 基础架构完成（第1-2阶段）
2. Swift组件完成（第3-4阶段）
3. 集成测试通过（第5阶段）