# macOS NSView Components Guide

## Overview
This document provides ASCII diagrams and usage scenarios for common macOS view components: NSOutlineView, NSTableView, NSSplitView, and NSStackView.

## NSOutlineView - Hierarchical Data Display

NSOutlineView is perfect for displaying tree-structured data with expandable/collapsible nodes.

### File Explorer Example:
```
┌─────────────────────────────────────┐
│ 📁 Project                     ▼    │
│   📁 Sources                   ▼    │
│     📄 main.swift                   │
│     📄 AppDelegate.swift            │
│     📁 Controllers             ▼    │
│       📄 MainViewController.swift   │
│       📄 SettingsViewController.swift│
│   📁 Resources                 ►    │
│   📁 Tests                     ►    │
└─────────────────────────────────────┘
```

### Key Features:
- Hierarchical data representation
- Expand/collapse functionality
- Multiple selection support
- Drag & drop support
- Custom cell views

### Common Use Cases:
- File browsers
- Navigation sidebars
- Category/subcategory lists
- Organizational charts

## NSTableView - Tabular Data Display

NSTableView displays data in rows and columns, similar to a spreadsheet.

### File List Example:
```
┌──────────────────────────────────────────────────────────┐
│ Name               │ Size      │ Modified    │ Type      │
├────────────────────┼───────────┼─────────────┼───────────┤
│ 📄 document.pdf    │ 2.3 MB    │ 2024-01-15  │ PDF       │
│ 📷 photo.jpg       │ 1.8 MB    │ 2024-01-14  │ Image     │
│ 📁 folder          │ --        │ 2024-01-13  │ Folder    │
│ 📄 readme.txt      │ 12 KB     │ 2024-01-12  │ Text      │
│ 🎵 music.mp3       │ 4.2 MB    │ 2024-01-11  │ Audio     │
└──────────────────────────────────────────────────────────┘
```

### Key Features:
- Column-based data display
- Sortable columns
- Resizable columns
- Cell-based editing
- Custom cell views

### Common Use Cases:
- Data tables
- List views with multiple columns
- Spreadsheet-like interfaces
- Database result displays

## NSSplitView - Adjustable Split Layouts

NSSplitView divides a view into resizable panes separated by dividers.

### Horizontal Split Example:
```
┌─────────────────────────────────────────────────┐
│                Top Pane                         │
│           (Navigation/Toolbar)                  │
├═════════════════════════════════════════════════┤ ← Divider
│                                                 │
│              Bottom Pane                        │
│            (Main Content)                       │
│                                                 │
└─────────────────────────────────────────────────┘
```

### Vertical Split Example:
```
┌─────────────────┬═══════════════════════════────┐
│                 ║                               │
│   Left Pane     ║         Right Pane            │
│   (Sidebar)     ║      (Main Content)           │
│                 ║                               │
│                 ║                               │
│                 ║                               │
│                 ║                               │
└─────────────────┴═══════════════════════════════┘
                  ↑ Draggable Divider
```

### Nested Split Views Example:
```
┌─────────────────┬═══════════════════════════════┐
│                 ║  ┌─────────────────────────┐  │
│                 ║  │     Top Right Pane      │  │
│   Left Pane     ║  │     (Editor Toolbar)    │  │
│   (Sidebar)     ║  ├─────────────────────────┤  │
│                 ║  │                         │  │
│                 ║  │   Bottom Right Pane     │  │
│                 ║  │    (Editor Content)     │  │
│                 ║  │                         │  │
└─────────────────┴══└─────────────────────────┘  │
                  ↑                               │
            Vertical Divider              Horizontal Divider
```

### Key Features:
- Resizable panes
- Collapsible sections
- Min/max size constraints
- Programmatic control
- Auto-save positions

### Common Use Cases:
- Sidebar + main content layouts
- Multi-pane editors
- Inspector panels
- Master-detail interfaces

## NSStackView - Auto-Layout Container

NSStackView arranges subviews in a single row or column with automatic spacing and alignment.

### Vertical Stack Example:
```
┌─────────────────────────────────────┐
│ ┌─────────────────────────────────┐ │
│ │           View 1                │ │ ← spacing
│ └─────────────────────────────────┘ │
│ ┌─────────────────────────────────┐ │
│ │           View 2                │ │ ← spacing
│ └─────────────────────────────────┘ │
│ ┌─────────────────────────────────┐ │
│ │           View 3                │ │
│ └─────────────────────────────────┘ │
└─────────────────────────────────────┘
```

### Horizontal Stack Example:
```
┌─────────────────────────────────────────────────────────┐
│ ┌─────────┐ ┌─────────┐ ┌─────────┐ ┌─────────┐       │
│ │ View 1  │ │ View 2  │ │ View 3  │ │ View 4  │       │
│ └─────────┘ └─────────┘ └─────────┘ └─────────┘       │
│      ↑           ↑           ↑                         │
│   spacing    spacing    spacing                        │
└─────────────────────────────────────────────────────────┘
```

### Nested Stack Views Example:
```
┌─────────────────────────────────────────────────────────┐
│                   Main Vertical Stack                   │
│ ┌─────────────────────────────────────────────────────┐ │
│ │                  Header View                        │ │
│ └─────────────────────────────────────────────────────┘ │
│ ┌─────────────────────────────────────────────────────┐ │
│ │            Horizontal Stack View                    │ │
│ │ ┌─────────┐ ┌─────────┐ ┌─────────┐ ┌─────────┐   │ │
│ │ │ Button1 │ │ Button2 │ │ Button3 │ │ Button4 │   │ │
│ │ └─────────┘ └─────────┘ └─────────┘ └─────────┘   │ │
│ └─────────────────────────────────────────────────────┘ │
│ ┌─────────────────────────────────────────────────────┐ │
│ │                 Content View                        │ │
│ └─────────────────────────────────────────────────────┘ │
└─────────────────────────────────────────────────────────┘
```

### Key Features:
- Automatic spacing management
- Flexible alignment options
- Distribution modes (fill, equal spacing, etc.)
- Hugging priorities
- Compression resistance

### Common Use Cases:
- Button groups
- Form layouts
- Toolbar arrangements
- Card layouts

## Component Comparison

| Component | Best For | Key Advantage | Complexity |
|-----------|----------|---------------|------------|
| NSOutlineView | Hierarchical data | Tree structure display | Medium |
| NSTableView | Tabular data | Column-based organization | Medium |
| NSSplitView | Layout division | User-resizable panes | Low |
| NSStackView | Simple layouts | Auto-layout simplification | Low |

## Real-World Application Example

### Typical macOS App Layout:
```
┌─────────────────────────────────────────────────────────────────┐
│                        Title Bar                                │
├─────────────────────────────────────────────────────────────────┤
│ ┌─────────────────┬═════════════════════════════════════════════┐ │
│ │                 ║ ┌─────────────────────────────────────────┐ │ │
│ │                 ║ │         Toolbar (NSStackView)           │ │ │
│ │   NSOutlineView ║ │  [Button] [Button] [Search Field]      │ │ │
│ │   (Sidebar)     ║ └─────────────────────────────────────────┘ │ │
│ │                 ║ ┌─────────────────────────────────────────┐ │ │
│ │ 📁 Category 1   ║ │                                         │ │ │
│ │   📄 Item 1     ║ │          NSTableView                    │ │ │
│ │   📄 Item 2     ║ │        (Content List)                   │ │ │
│ │ 📁 Category 2   ║ │                                         │ │ │
│ │   📄 Item 3     ║ │ Name     │ Date     │ Size              │ │ │
│ │                 ║ │ ────────┼─────────┼───────             │ │ │
│ │                 ║ │ File 1   │ Today   │ 1.2MB              │ │ │
│ │                 ║ │ File 2   │ Yesterday│ 856KB             │ │ │
│ │                 ║ └─────────────────────────────────────────┘ │ │
│ └─────────────────┴═════════════════════════════════════════════┘ │
└─────────────────────────────────────────────────────────────────┘
```

This example combines:
- **NSSplitView**: Main layout division (sidebar + content)
- **NSOutlineView**: Hierarchical navigation (sidebar)
- **NSStackView**: Toolbar button arrangement
- **NSTableView**: Content display with columns

## Best Practices

1. **NSOutlineView**: Use for hierarchical data with clear parent-child relationships
2. **NSTableView**: Ideal for tabular data with sortable columns
3. **NSSplitView**: Perfect for resizable interface sections
4. **NSStackView**: Great for simple, auto-layout driven arrangements

## Implementation Notes

- All these components work well with Auto Layout
- They support both programmatic and Interface Builder setup
- Custom cell views can be implemented for enhanced functionality
- Delegate and data source patterns are commonly used for data management